/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn;

import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.hadoop.yarn.IFairSchedulerXmlGenerator;
import com.flipkart.fdp.irm.hadoop.yarn.IYarnHelper;
import com.flipkart.fdp.irm.hadoop.yarn.QueueDetails;
import com.google.inject.Inject;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CFairSchedulerXmlGenerator
implements IFairSchedulerXmlGenerator {
    private static final Logger log = LoggerFactory.getLogger(CFairSchedulerXmlGenerator.class);
    @Inject
    private IYarnHelper yarnHelper;
    private Document document;

    @Override
    public String getFairSchedulerXml(QueueDetails queueDetails) throws EBase {
        return this.createDocument(queueDetails);
    }

    private String createDocument(QueueDetails queueDetails) throws EFailure {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
            return this.createDOMTree(queueDetails);
        }
        catch (ParserConfigurationException e) {
            log.error("Error while trying to instantiate DocumentBuilder", (Throwable)e);
            throw new EFailure("Error while trying to instantiate DocumentBuilder");
        }
    }

    private String createDOMTree(QueueDetails queueDetails) {
        Element rootElement = this.document.createElement("allocations");
        this.document.appendChild(rootElement);
        Element queuePlacementPolicy = this.document.createElement("queuePlacementPolicy");
        Element rule = this.document.createElement("rule");
        rule.setAttribute("name", "reject");
        queuePlacementPolicy.appendChild(rule);
        rootElement.appendChild(queuePlacementPolicy);
        Element queueElement = this.getQueueElement(queueDetails);
        rootElement.appendChild(queueElement);
        return this.getStringFromDocument(this.document);
    }

    private Element getQueueElement(QueueDetails queueDetails) {
        Element queueToAdd = this.createQueueElement(queueDetails);
        for (QueueDetails children : queueDetails.getChildQueues()) {
            Element queue = this.getQueueElement(children);
            queueToAdd.appendChild(queue);
        }
        return queueToAdd;
    }

    private Element createQueueElement(QueueDetails queueDetails) {
        Element queue = this.document.createElement("queue");
        queue.setAttribute("name", queueDetails.getQueueName());
        Element minResources = this.document.createElement("minResources");
        Text minResourcesText = this.document.createTextNode(queueDetails.getMinResources().getMemory() + " mb, " + queueDetails.getMinResources().getCpuCount() + "vcores");
        minResources.appendChild(minResourcesText);
        queue.appendChild(minResources);
        Element maxResources = this.document.createElement("maxResources");
        Text maxResourcesText = this.document.createTextNode(queueDetails.getMaxResources().getMemory() + " mb, " + queueDetails.getMaxResources().getCpuCount() + "vcores");
        maxResources.appendChild(maxResourcesText);
        queue.appendChild(maxResources);
        Element schedulingPolicy = this.document.createElement("schedulingPolicy");
        Text schedulingPolicyText = this.document.createTextNode("drf");
        schedulingPolicy.appendChild(schedulingPolicyText);
        queue.appendChild(schedulingPolicy);
        Element aclSubmitApps = this.document.createElement("aclSubmitApps");
        Text aclSubmitAppsText = this.document.createTextNode(queueDetails.getUserName());
        aclSubmitApps.appendChild(aclSubmitAppsText);
        queue.appendChild(aclSubmitApps);
        Element aclAdministerApps = this.document.createElement("aclAdministerApps");
        Text aclAdministerAppsText = this.document.createTextNode(queueDetails.getUserName());
        aclAdministerApps.appendChild(aclAdministerAppsText);
        queue.appendChild(aclAdministerApps);
        return queue;
    }

    public String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

