/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn.clients;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.fdp.irm.core.clients.IClusterClient;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.flipkart.fdp.irm.webentities.ClusterMetricsInfo;
import com.flipkart.fdp.irm.webentities.YarnClusterUsage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CYarnClusterClient
implements IClusterClient<YarnClusterUsage> {
    private static final Logger log = LoggerFactory.getLogger(CYarnClusterClient.class);
    private static final String METRICS_URL = "ws/v1/cluster/metrics";
    private String rmUrl;
    private RestConnector restConnector;

    public CYarnClusterClient(String rmUrl) throws EFailure {
        this.rmUrl = rmUrl;
        this.restConnector = new RestConnector();
    }

    public YarnClusterUsage getClusterQuotaDetails() throws EFailure {
        YarnClusterUsage yarnClusterUsage;
        try {
            String getMetricsUrl = this.rmUrl.concat(METRICS_URL);
            URI getMetricsUri = new URI(getMetricsUrl);
            String response = this.restConnector.hitGetURI(getMetricsUri, Optional.empty());
            log.debug("Response:  {}", (Object)response);
            JsonNode rootNode = (JsonNode)CommonUtils.OBJECT_MAPPER.readValue(response, JsonNode.class);
            ClusterMetricsInfo clusterMetricsInfo = (ClusterMetricsInfo)CommonUtils.OBJECT_MAPPER.readValue(rootNode.get("clusterMetrics").toString(), ClusterMetricsInfo.class);
            yarnClusterUsage = this.getYarnClusterUsage(clusterMetricsInfo);
        }
        catch (URISyntaxException e) {
            log.error("Exception while Forming yarn cluster metrics Url {}", (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
        catch (IOException e) {
            log.error("Exception while Forming yarn cluster stats {}", (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
        return yarnClusterUsage;
    }

    private YarnClusterUsage getYarnClusterUsage(ClusterMetricsInfo clusterMetricsInfo) {
        YarnClusterUsage yarnClusterUsage = new YarnClusterUsage();
        long totalCpu = clusterMetricsInfo.getTotalVirtualCores();
        long availableCpu = clusterMetricsInfo.getAvailableVirtualCores();
        long totalMemory = clusterMetricsInfo.getTotalMB();
        long availableMemory = clusterMetricsInfo.getAvailableMB();
        yarnClusterUsage.setCpuTotal(totalCpu);
        yarnClusterUsage.setCpuUsed(totalCpu - availableCpu);
        yarnClusterUsage.setCpuAvailable(availableCpu);
        yarnClusterUsage.setMemoryAvailabledMB(availableMemory);
        yarnClusterUsage.setMemoryTotalMB(totalMemory);
        yarnClusterUsage.setMemoryUsedMB(totalMemory - availableMemory);
        return yarnClusterUsage;
    }
}

