/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn.facade;

import com.flipkart.fdp.irm.core.dao.IResourceProfileDao;
import com.flipkart.fdp.irm.core.facade.IResourceProfileFacade;
import com.flipkart.fdp.irm.core.facade.ResourceProfileFacade;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.ENotYetImplemented;
import com.flipkart.fdp.irm.hadoop.yarn.db.YarnProfile;
import com.flipkart.fdp.irm.webentities.ResourceProfileWebEntity;
import com.flipkart.fdp.irm.webentities.YarnProfileWebEntity;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CYarnProfileFacade
extends ResourceProfileFacade<YarnProfile>
implements IResourceProfileFacade {
    private static final Logger log = LoggerFactory.getLogger(CYarnProfileFacade.class);
    private IResourceProfileDao<YarnProfile> yarnProfileDao;

    @Inject
    public CYarnProfileFacade(IResourceProfileDao<YarnProfile> yarnProfileDao) {
        this.yarnProfileDao = yarnProfileDao;
    }

    public ResourceProfileWebEntity createProfile(ResourceProfileWebEntity yarnProfile) throws EBase {
        YarnProfile yarnProfileDbEntity = this.toDbEntity(yarnProfile);
        YarnProfile createdYarnProfile = (YarnProfile)((Object)this.yarnProfileDao.save((Object)yarnProfileDbEntity));
        this.toWebEntity(createdYarnProfile);
        throw new ENotYetImplemented();
    }

    public ResourceProfileWebEntity getProfile(Long profileId) throws EBase {
        return this.toWebEntity((YarnProfile)((Object)this.yarnProfileDao.getById(profileId)));
    }

    public ResourceProfileWebEntity deleteProfile(Long profileId) throws EBase {
        YarnProfile yarnProfile = (YarnProfile)((Object)this.yarnProfileDao.deleteById(profileId));
        this.toWebEntity(yarnProfile);
        throw new ENotYetImplemented();
    }

    public List<ResourceProfileWebEntity> getAllProfiles() throws EBase {
        return this.toWebEntityList(this.yarnProfileDao.getAll());
    }

    protected YarnProfile toDbEntity(ResourceProfileWebEntity yarnProfileWebEntity) {
        YarnProfile yarnProfile = new YarnProfile();
        yarnProfile.setDescription(yarnProfileWebEntity.getDescription());
        yarnProfile.setMemory(((YarnProfileWebEntity)yarnProfileWebEntity).getMemory());
        yarnProfile.setMemoryUnit(((YarnProfileWebEntity)yarnProfileWebEntity).getMemoryUnit());
        yarnProfile.setCpuCount(((YarnProfileWebEntity)yarnProfileWebEntity).getCpuCount());
        return yarnProfile;
    }

    protected ResourceProfileWebEntity toWebEntity(YarnProfile yarnProfile) {
        YarnProfileWebEntity yarnProfileWebEntity = new YarnProfileWebEntity(yarnProfile.getDescription(), yarnProfile.getCpuCount(), yarnProfile.getMemory(), yarnProfile.getMemoryUnit());
        yarnProfileWebEntity.setId(yarnProfile.getId());
        return yarnProfileWebEntity;
    }

    protected List<ResourceProfileWebEntity> toWebEntityList(List<YarnProfile> yarnProfileList) {
        return FluentIterable.from(yarnProfileList).transform((Function)new Function<YarnProfile, ResourceProfileWebEntity>(){

            public ResourceProfileWebEntity apply(YarnProfile input) {
                return CYarnProfileFacade.this.toWebEntity(input);
            }
        }).toList();
    }
}

