/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.java.client;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.fdp.irm.java.client.IRMClientException;
import com.flipkart.fdp.irm.java.client.IRMServiceException;
import com.flipkart.fdp.irm.java.client.cluster.enpoint.AddDataprocEndpointRequest;
import com.flipkart.fdp.irm.java.client.cluster.enpoint.AddHadoopEndpointRequest;
import com.flipkart.fdp.irm.java.client.cluster.enpoint.GetEndpointByClusterIdRequest;
import com.flipkart.fdp.irm.java.client.clusters.CreateClusterRequest;
import com.flipkart.fdp.irm.java.client.clusters.ListClustersRequest;
import com.flipkart.fdp.irm.java.client.resource.GetResourceByIdRequest;
import com.flipkart.fdp.irm.java.client.resource.endpoint.GetEndpointByResourceIdRequest;
import com.flipkart.fdp.irm.java.client.resources.CreateResourceRequest;
import com.flipkart.fdp.irm.java.client.resources.ListResourcesRequest;
import com.flipkart.fdp.irm.java.client.utils.JsonUtils;
import com.google.common.base.Function;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRMServiceClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(IRMServiceClient.class);
    public static final int DEFAULT_REQUEST_TIMEOUT_SECONDS = 60000;
    public static final String BASE_PATH = "/irm/v1";
    private final String baseUrl;
    private final int requestTimeoutMillis;
    private final AsyncHttpClient asyncHttpClient;

    public IRMServiceClient(String host, int port) {
        this(host, port, 60000, new AsyncHttpClient());
    }

    public IRMServiceClient(String host, int port, int requestTimeoutMillis) {
        this(host, port, requestTimeoutMillis, new AsyncHttpClient());
    }

    public IRMServiceClient(String host, int port, int requestTimeoutMillis, AsyncHttpClient asyncHttpClient) {
        this.baseUrl = "http://" + host + (port != 80 ? ":" + port : "") + BASE_PATH;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public void close() {
        this.asyncHttpClient.close();
    }

    public ListResourcesRequest listResources() {
        return new ListResourcesRequest(this);
    }

    public ListClustersRequest listClusters() {
        return new ListClustersRequest(this);
    }

    public AddHadoopEndpointRequest addHadoopEndpoint(long clusterId) {
        return new AddHadoopEndpointRequest(clusterId, this);
    }

    public GetEndpointByResourceIdRequest listEndPointsForResource(long resourceId, String resourceType) {
        return new GetEndpointByResourceIdRequest(resourceId, resourceType, this);
    }

    public GetEndpointByClusterIdRequest getEndpointByClusterId(long clusterId) {
        return new GetEndpointByClusterIdRequest(clusterId, this);
    }

    public CreateResourceRequest createResource() {
        return new CreateResourceRequest(this);
    }

    public CreateClusterRequest createCluster() {
        return new CreateClusterRequest(this);
    }

    public GetResourceByIdRequest getResourceById(long resourceId) {
        return new GetResourceByIdRequest(resourceId, this);
    }

    public AddDataprocEndpointRequest addDataprocEndpoint(long clusterId) {
        return new AddDataprocEndpointRequest(clusterId, this);
    }

    public <R> R executesSync(String method, String path, JavaType type, Function<RequestBuilder, RequestBuilder> function) {
        try {
            RequestBuilder requestBuilder = (RequestBuilder)new RequestBuilder(method).setUrl(this.baseUrl + path).setRequestTimeout(this.requestTimeoutMillis);
            Request request = ((RequestBuilder)function.apply((Object)requestBuilder)).build();
            Response response = (Response)this.asyncHttpClient.executeRequest(request).get();
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                return (R)JsonUtils.DEFAULT.mapper.readValue(response.getResponseBody(), type);
            }
            Error error = (Error)JsonUtils.DEFAULT.mapper.readValue(response.getResponseBody(), Error.class);
            throw new IRMServiceException(error);
        }
        catch (IRMServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IRMClientException(e);
        }
    }
}

