/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.java.client.cluster;

import com.flipkart.fdp.irm.java.client.AbstractIRMServiceRequest;
import com.flipkart.fdp.irm.java.client.IRMServiceClient;
import com.google.common.base.Preconditions;
import javax.validation.constraints.NotNull;

public abstract class AbstractClusterRequest<T>
extends AbstractIRMServiceRequest<T> {
    protected static final String RESOURCE_PATH_CLUSTER_ID_PLACEHOLDER = ":clusterId";
    protected static final String RESOURCE_PATH = "/clusters/:clusterId";
    private final Long clusterId;

    public AbstractClusterRequest(@NotNull Long clusterId, IRMServiceClient client) {
        super(client);
        this.clusterId = clusterId;
    }

    @Override
    protected void validateReadiness() {
        super.validateReadiness();
        Preconditions.checkNotNull((Object)this.clusterId, (Object)"clusterId is required and cannot be null");
    }

    @Override
    protected String getPath() {
        return RESOURCE_PATH.replaceAll(RESOURCE_PATH_CLUSTER_ID_PLACEHOLDER, Long.toString(this.clusterId));
    }
}

