/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.java.client;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.fdp.irm.java.client.IRMServiceClient;
import com.flipkart.fdp.irm.java.client.IRMServiceRequest;
import com.google.common.base.Function;
import com.ning.http.client.RequestBuilder;

public abstract class AbstractIRMServiceRequest<T>
implements IRMServiceRequest<T> {
    protected final IRMServiceClient client;

    public AbstractIRMServiceRequest(IRMServiceClient client) {
        this.client = client;
    }

    @Override
    public T executeSync() throws Exception {
        return (T)this.client.executesSync(this.getMethod(), this.getPath(), this.getReturnType(), (Function<RequestBuilder, RequestBuilder>)((Function)this::buildRequest));
    }

    protected abstract String getMethod();

    protected abstract String getPath();

    protected abstract JavaType getReturnType();

    protected void validateReadiness() {
    }

    protected abstract RequestBuilder buildRequest(RequestBuilder var1);

    protected void addFormParam(RequestBuilder requestBuilder, String key, String value) {
        if (value != null) {
            requestBuilder.addFormParam(key, value);
        }
    }

    protected <V> void addFormParam(RequestBuilder requestBuilder, String key, V value, Function<V, String> transform) {
        if (value != null) {
            String transformedValue = (String)transform.apply(value);
            this.addFormParam(requestBuilder, key, transformedValue);
        }
    }

    protected void addQueryParam(RequestBuilder requestBuilder, String key, String value) {
        if (value != null) {
            requestBuilder.addQueryParam(key, value);
        }
    }

    protected <V> void addQueryParam(RequestBuilder requestBuilder, String key, V value, Function<V, String> transform) {
        if (value != null) {
            String transformedValue = (String)transform.apply(value);
            this.addQueryParam(requestBuilder, key, transformedValue);
        }
    }
}

