/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.java.client.clusters;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.fdp.irm.enums.ClusterManagerType;
import com.flipkart.fdp.irm.enums.ClusterType;
import com.flipkart.fdp.irm.enums.Status;
import com.flipkart.fdp.irm.java.client.IRMServiceClient;
import com.flipkart.fdp.irm.java.client.clusters.AbstractClustersRequest;
import com.flipkart.fdp.irm.java.client.utils.JsonUtils;
import com.flipkart.fdp.irm.webentities.ClusterWebEntity;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import javax.validation.constraints.NotNull;

public class CreateClusterRequest
extends AbstractClustersRequest<ClusterWebEntity> {
    private Long zoneId;
    private Status status;
    private ClusterType clusterType;
    private String description;
    private ClusterManagerType clusterManagerType;

    public CreateClusterRequest(IRMServiceClient client) {
        super(client);
    }

    @Override
    protected String getMethod() {
        return "POST";
    }

    @Override
    protected JavaType getReturnType() {
        return JsonUtils.DEFAULT.mapper.getTypeFactory().constructType(ClusterWebEntity.class);
    }

    @Override
    public RequestBuilder buildRequest(RequestBuilder requestBuilder) {
        ClusterWebEntity clusterWebEntity = new ClusterWebEntity(this.description, this.clusterType, this.status, this.clusterManagerType, this.zoneId);
        try {
            requestBuilder.addHeader("Content-type", "application/json");
            requestBuilder.setBody(JsonUtils.DEFAULT.mapper.writeValueAsString((Object)clusterWebEntity));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return requestBuilder;
    }

    public CreateClusterRequest zoneId(@NotNull Long zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public CreateClusterRequest status(@NotNull Status status) {
        this.status = status;
        return this;
    }

    public CreateClusterRequest clusterType(@NotNull ClusterType clusterType) {
        this.clusterType = clusterType;
        return this;
    }

    public CreateClusterRequest clusterManagerType(@NotNull ClusterManagerType clusterManagerType) {
        this.clusterManagerType = clusterManagerType;
        return this;
    }

    public CreateClusterRequest description(@NotNull String description) {
        this.description = description;
        return this;
    }
}

