/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.java.client.resource.endpoint;

import com.flipkart.fdp.irm.java.client.AbstractIRMServiceRequest;
import com.flipkart.fdp.irm.java.client.IRMServiceClient;
import com.google.common.base.Preconditions;
import javax.validation.constraints.NotNull;

public abstract class AbstractResourceEndpointRequest<T>
extends AbstractIRMServiceRequest<T> {
    protected static final String RESOURCE_PATH_RESOURCE_ID_PLACEHOLDER = ":resourceId";
    protected static final String RESOURCE_PATH = "/resources/:resourceId/endpoints/";
    private final long resourceId;

    public AbstractResourceEndpointRequest(@NotNull long resourceId, IRMServiceClient client) {
        super(client);
        this.resourceId = resourceId;
    }

    @Override
    protected void validateReadiness() {
        super.validateReadiness();
        Preconditions.checkNotNull((Object)this.resourceId, (Object)"resourceId is required and cannot be null");
    }

    @Override
    protected String getPath() {
        return RESOURCE_PATH.replaceAll(RESOURCE_PATH_RESOURCE_ID_PLACEHOLDER, Long.toString(this.resourceId));
    }
}

