/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.java.client.resources;

import com.fasterxml.jackson.databind.JavaType;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.java.client.IRMServiceClient;
import com.flipkart.fdp.irm.java.client.resources.AbstractResourcesRequest;
import com.flipkart.fdp.irm.java.client.utils.JsonUtils;
import com.flipkart.fdp.irm.webentities.ResourceWebEntity;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import javax.validation.constraints.NotNull;

public class CreateResourceRequest
extends AbstractResourcesRequest<ResourceWebEntity> {
    private long clusterId;
    private String org;
    private String namespace;
    private ResourceType resourceType;
    private String description;
    private String token;

    public CreateResourceRequest(IRMServiceClient client) {
        super(client);
    }

    @Override
    protected String getMethod() {
        return "POST";
    }

    @Override
    protected JavaType getReturnType() {
        return JsonUtils.DEFAULT.mapper.getTypeFactory().constructType(ResourceWebEntity.class);
    }

    @Override
    public RequestBuilder buildRequest(RequestBuilder requestBuilder) {
        ResourceWebEntity resourceWebEntity = new ResourceWebEntity(Long.valueOf(this.clusterId), this.namespace, this.org, this.resourceType, this.description);
        if (this.token != null) {
            resourceWebEntity.setToken(this.token);
        }
        try {
            requestBuilder.addHeader("Content-type", "application/json");
            String value = JsonUtils.DEFAULT.mapper.writeValueAsString((Object)resourceWebEntity);
            requestBuilder.setBody(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return requestBuilder;
    }

    public CreateResourceRequest clusterId(@NotNull long clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public CreateResourceRequest org(@NotNull String org) {
        this.org = org;
        return this;
    }

    public CreateResourceRequest namespace(@NotNull String namespace) {
        this.namespace = namespace;
        return this;
    }

    public CreateResourceRequest resourceType(@NotNull ResourceType resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public CreateResourceRequest description(@NotNull String description) {
        this.description = description;
        return this;
    }

    public CreateResourceRequest token(@NotNull String token) {
        this.token = token;
        return this;
    }
}

