/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.java.client.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public enum JsonUtils {
    DEFAULT(new ObjectMapper()),
    PRETTY(new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT));

    public final ObjectMapper mapper;

    private JsonUtils(ObjectMapper mapper) {
        this.mapper = mapper;
        mapper.findAndRegisterModules();
    }

    public <T> String toJson(T object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> byte[] toJsonBinary(T object) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(byte[] json, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> asMap(String jsonString) {
        try {
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)this.mapper.readValue(jsonString, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> asMap(byte[] jsonString) {
        try {
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            return (Map)this.mapper.readValue(jsonString, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

