/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.fdp.irm.exceptions.EInvalid;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class CommonUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String NAME_SEPARATOR = "-";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static URI constructURI(String baseURL, String path, Map<String, String> queryParams) throws URISyntaxException {
        URIBuilder uribuilder = new URIBuilder(URI.create(baseURL)).setPath(path);
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                uribuilder.addParameter(entry.getKey(), entry.getValue());
            }
        }
        return uribuilder.build();
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> enumClass, String value) throws EInvalid {
        if (enumClass == null) {
            throw new IllegalArgumentException("EnumClass value can't be null.");
        }
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            if (!enumValue.toString().equalsIgnoreCase(value)) continue;
            return (T)enumValue;
        }
        StringBuilder errorMessage = new StringBuilder();
        boolean bFirstTime = true;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            errorMessage.append(bFirstTime ? "" : ", ").append(enumValue);
            bFirstTime = false;
        }
        throw new EInvalid(value + " is invalid value. Supported values are " + errorMessage);
    }
}

