/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.utils;

import com.flipkart.fdp.irm.exceptions.EFailure;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnector {
    private static final Logger log = LoggerFactory.getLogger(RestConnector.class);
    private HttpClient httpClient = HttpClientBuilder.create().build();
    private String authEncoding;

    public String hitGetURI(URI uri, Optional<Header[]> httpHeaders) throws EFailure {
        try {
            log.debug("Starting Get Call: " + uri);
            HttpGet getUri = new HttpGet(uri);
            getUri.setHeader("Content-Type", "application/json");
            if (httpHeaders.isPresent()) {
                getUri.setHeaders(httpHeaders.get());
            }
            getUri.setHeader("Authorization", "Basic " + this.authEncoding);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)getUri);
            int status = response.getStatusLine().getStatusCode();
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            log.debug("Completed Get Call: " + uri);
            if (status == Response.Status.OK.getStatusCode()) {
                return entity;
            }
            throw new EFailure("Rest Get returned non OK status code of - " + status + ", for URI: " + uri + ", Response := " + entity);
        }
        catch (Exception e) {
            log.error("Exception processing request!", (Throwable)e);
            throw new EFailure(e);
        }
    }

    public String hitPostURI(URI uri, String data, Optional<Header[]> httpHeaders) throws EFailure {
        try {
            log.debug("Starting Post Call: " + uri + ", Data: " + data);
            HttpPost postUri = new HttpPost(uri);
            postUri.setHeader("Content-Type", "application/json");
            if (httpHeaders.isPresent()) {
                postUri.setHeaders(httpHeaders.get());
            }
            postUri.setHeader("Authorization", "Basic " + this.authEncoding);
            postUri.setEntity((HttpEntity)new StringEntity(data));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)postUri);
            int status = response.getStatusLine().getStatusCode();
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            log.debug("Completed Post Call: " + uri);
            if (status == Response.Status.OK.getStatusCode() || status == Response.Status.ACCEPTED.getStatusCode() || status == Response.Status.CREATED.getStatusCode()) {
                return entity;
            }
            throw new EFailure("Rest Post returned non OK/CREATED/ACCEPTED status code of - " + status + ", for URI: " + uri + ", with Data: " + data + ", Response := " + entity);
        }
        catch (Exception e) {
            log.error("Exception processing request!", (Throwable)e);
            throw new EFailure(e);
        }
    }

    public String hitPutURI(URI uri, Optional<String> data, Optional<Header[]> httpHeaders) throws EFailure {
        try {
            log.debug("Starting Put Call: " + uri + ", Data: " + data.get());
            HttpPut putUri = new HttpPut(uri);
            putUri.setHeader("Content-Type", "application/json");
            if (httpHeaders.isPresent()) {
                putUri.setHeaders(httpHeaders.get());
            }
            putUri.setHeader("Authorization", "Basic " + this.authEncoding);
            putUri.setEntity((HttpEntity)new StringEntity(data.get()));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)putUri);
            int status = response.getStatusLine().getStatusCode();
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            log.debug("Completed Put Call: " + uri);
            if (status == Response.Status.OK.getStatusCode()) {
                return entity;
            }
            throw new EFailure("Rest Put returned non OK status code of - " + status + ", for URI: " + uri + ", with Data: " + data.get() + ", Response := " + entity);
        }
        catch (Exception e) {
            log.error("Exception processing request!", (Throwable)e);
            throw new EFailure(e);
        }
    }

    public String getAuthEncoding() {
        return this.authEncoding;
    }

    public void setAuthEncoding(String username, String password) {
        byte[] bytes = String.format("%s:%s", username, password).getBytes(Charset.forName("UTF-8"));
        this.authEncoding = Base64.encodeBase64String((byte[])bytes);
    }
}

