/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clusterManagers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.clusterManagers.ClusterManagerDetails;
import io.swagger.annotations.ApiModel;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@ApiModel(description="Ambari cluster manager details.", parent=ClusterManagerDetails.class)
public class AmbariClusterDetails
extends ClusterManagerDetails {
    @JsonProperty
    private String clusterName;
    @JsonProperty
    private String server;
    @JsonProperty
    private String user;
    @JsonProperty
    private String passwd;
    @JsonProperty
    @Min(value=1024L)
    @Max(value=65535L)
    private int port;

    @JsonCreator
    public AmbariClusterDetails(@JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="user") String user, @JsonProperty(value="passwd") String passwd, @JsonProperty(value="server") String server, @JsonProperty(value="port") int port) {
        this.clusterName = clusterName;
        this.user = user;
        this.passwd = passwd;
        this.server = server;
        this.port = port;
    }

    public String getBaseUrl() {
        return "http://" + this.server + ":" + this.port + "/";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmbariClusterDetails)) {
            return false;
        }
        AmbariClusterDetails other = (AmbariClusterDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$passwd = this.getPasswd();
        String other$passwd = other.getPasswd();
        if (this$passwd == null ? other$passwd != null : !this$passwd.equals(other$passwd)) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AmbariClusterDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 0 : $clusterName.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 0 : $server.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 0 : $user.hashCode());
        String $passwd = this.getPasswd();
        result = result * 59 + ($passwd == null ? 0 : $passwd.hashCode());
        result = result * 59 + this.getPort();
        return result;
    }

    @Override
    public String toString() {
        return "AmbariClusterDetails(super=" + super.toString() + ", clusterName=" + this.getClusterName() + ", server=" + this.getServer() + ", user=" + this.getUser() + ", passwd=" + this.getPasswd() + ", port=" + this.getPort() + ")";
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public int getPort() {
        return this.port;
    }
}

