/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.flipkart.fdp.irm.clusterConfigs.ClusterConfigurations;
import com.flipkart.fdp.irm.clusterConfigs.HadoopConfigurations;
import com.flipkart.fdp.irm.endpoints.ClusterEndpoints;
import com.flipkart.fdp.irm.endpoints.DataprocClusterEndpoints;
import com.flipkart.fdp.irm.endpoints.ElasticsearchClusterEndpoints;
import com.flipkart.fdp.irm.endpoints.HadoopClusterEndpoints;
import com.flipkart.fdp.irm.endpoints.KafkaClusterEndpoints;
import com.flipkart.fdp.irm.exceptions.EInvalid;
import com.flipkart.fdp.irm.utils.CommonUtils;

public enum ClusterType {
    HADOOP(HadoopClusterEndpoints.class, HadoopConfigurations.class),
    KAFKA(KafkaClusterEndpoints.class, null),
    ELASTICSEARCH(ElasticsearchClusterEndpoints.class, null),
    DATAPROC(DataprocClusterEndpoints.class, null);

    private final Class<? extends ClusterEndpoints> endPointClass;
    private final Class<? extends ClusterConfigurations> clusterConfigsClass;

    private ClusterType(Class<? extends ClusterEndpoints> endPointClass, Class<? extends ClusterConfigurations> clusterConfigsClass) {
        this.endPointClass = endPointClass;
        this.clusterConfigsClass = clusterConfigsClass;
    }

    @JsonCreator
    public static ClusterType fromValue(String value) throws EInvalid {
        return (ClusterType)CommonUtils.getEnumFromString(ClusterType.class, (String)value);
    }

    public Class<? extends ClusterEndpoints> getEndpointsClass() {
        return this.endPointClass;
    }

    public Class<? extends ClusterConfigurations> getClusterConfigsClass() {
        return this.clusterConfigsClass;
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }
}

