/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.flipkart.fdp.irm.exceptions.EInvalid;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.webentities.HdfsQuotaWebEntity;
import com.flipkart.fdp.irm.webentities.KafkaQuotaWebEntity;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import com.flipkart.fdp.irm.webentities.YarnQuotaWebEntity;

public enum ResourceType {
    HDFS(HdfsQuotaWebEntity.class),
    YARN(YarnQuotaWebEntity.class),
    KAFKA(KafkaQuotaWebEntity.class),
    GCS(null);

    private final Class<? extends QuotaWebEntity> quotaEntityClass;

    private ResourceType(Class<? extends QuotaWebEntity> quotaEntityClass) {
        this.quotaEntityClass = quotaEntityClass;
    }

    @JsonCreator
    public static ResourceType fromValue(String value) throws EInvalid {
        return (ResourceType)CommonUtils.getEnumFromString(ResourceType.class, (String)value);
    }

    public Class<? extends QuotaWebEntity> getQuotaEntityClass() {
        return this.quotaEntityClass;
    }

    @JsonValue
    public String toJson() {
        return this.name().toLowerCase();
    }
}

