/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@ApiModel(description="Ambari Cluster Details object, it hold information of a cluster.")
public class AmbariClusterDetailsWebEntity {
    @JsonProperty
    @NotNull
    @Pattern(regexp="^[a-zA-Z][a-zA-Z0-9]*$", message="Invalid name, you can only use alphabets with the combination of numbers.")
    @ApiModelProperty(value="Name of a cluster, it should be unique.", required=true)
    private String clusterName;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Tag associated with ambari cluster", required=true)
    private String tag;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Ambari User name", required=true)
    private String ambariUser;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Ambari User password", required=true)
    private String ambariPasswd;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Ambari cluster base url", required=true)
    private String baseUrl;

    @JsonCreator
    public AmbariClusterDetailsWebEntity(@JsonProperty(value="clusterId") String clusterName, @JsonProperty(value="baseUrl") String baseUrl, @JsonProperty(value="ambariUser") String ambariUser, @JsonProperty(value="ambariPasswd") String ambariPasswd, @JsonProperty(value="tag") String tag) {
        this.clusterName = clusterName;
        this.baseUrl = baseUrl;
        this.ambariUser = ambariUser;
        this.ambariPasswd = ambariPasswd;
        this.tag = tag;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getTag() {
        return this.tag;
    }

    public String getAmbariUser() {
        return this.ambariUser;
    }

    public String getAmbariPasswd() {
        return this.ambariPasswd;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String toString() {
        return "AmbariClusterDetailsWebEntity(clusterName=" + this.getClusterName() + ", tag=" + this.getTag() + ", ambariUser=" + this.getAmbariUser() + ", ambariPasswd=" + this.getAmbariPasswd() + ", baseUrl=" + this.getBaseUrl() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmbariClusterDetailsWebEntity)) {
            return false;
        }
        AmbariClusterDetailsWebEntity other = (AmbariClusterDetailsWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$ambariUser = this.getAmbariUser();
        String other$ambariUser = other.getAmbariUser();
        if (this$ambariUser == null ? other$ambariUser != null : !this$ambariUser.equals(other$ambariUser)) {
            return false;
        }
        String this$ambariPasswd = this.getAmbariPasswd();
        String other$ambariPasswd = other.getAmbariPasswd();
        if (this$ambariPasswd == null ? other$ambariPasswd != null : !this$ambariPasswd.equals(other$ambariPasswd)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AmbariClusterDetailsWebEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 0 : $clusterName.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 0 : $tag.hashCode());
        String $ambariUser = this.getAmbariUser();
        result = result * 59 + ($ambariUser == null ? 0 : $ambariUser.hashCode());
        String $ambariPasswd = this.getAmbariPasswd();
        result = result * 59 + ($ambariPasswd == null ? 0 : $ambariPasswd.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 0 : $baseUrl.hashCode());
        return result;
    }
}

