/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.enums.ClusterManagerType;
import com.flipkart.fdp.irm.enums.ClusterType;
import com.flipkart.fdp.irm.enums.Status;
import com.flipkart.fdp.irm.webentities.BaseWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotNull;

@ApiModel(description="Cluster object, it hold information of a cluster.")
public class ClusterWebEntity
extends BaseWebEntity {
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Description about cluster.", required=true)
    private String description;
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of cluster.", required=true, allowableValues="HADOOP,KAFKA,ZOOKEEPER,VERTICA")
    private ClusterType clusterType;
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="status of cluster eg. UP or DOWN.", required=true, allowableValues="UP,DOWN")
    private Status status;
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of cluster Manager.", required=true, allowableValues="AMBARI,NULL")
    private ClusterManagerType clusterManagerType;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Unique name of zone")
    private Long zoneId;

    @JsonCreator
    public ClusterWebEntity(@JsonProperty(value="description") String description, @JsonProperty(value="clusterType") ClusterType clusterType, @JsonProperty(value="status") Status status, @JsonProperty(value="clusterManagerType") ClusterManagerType clusterManagerType, @JsonProperty(value="zoneId") Long zoneId) {
        this.description = description;
        this.clusterType = clusterType;
        this.status = status;
        this.clusterManagerType = clusterManagerType;
        this.zoneId = zoneId;
    }

    public String getDescription() {
        return this.description;
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public Status getStatus() {
        return this.status;
    }

    public ClusterManagerType getClusterManagerType() {
        return this.clusterManagerType;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    @Override
    public String toString() {
        return "ClusterWebEntity(description=" + this.getDescription() + ", clusterType=" + (Object)((Object)this.getClusterType()) + ", status=" + (Object)((Object)this.getStatus()) + ", clusterManagerType=" + (Object)((Object)this.getClusterManagerType()) + ", zoneId=" + this.getZoneId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterWebEntity)) {
            return false;
        }
        ClusterWebEntity other = (ClusterWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ClusterType this$clusterType = this.getClusterType();
        ClusterType other$clusterType = other.getClusterType();
        if (this$clusterType == null ? other$clusterType != null : !((Object)((Object)this$clusterType)).equals((Object)other$clusterType)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ClusterManagerType this$clusterManagerType = this.getClusterManagerType();
        ClusterManagerType other$clusterManagerType = other.getClusterManagerType();
        if (this$clusterManagerType == null ? other$clusterManagerType != null : !((Object)((Object)this$clusterManagerType)).equals((Object)other$clusterManagerType)) {
            return false;
        }
        Long this$zoneId = this.getZoneId();
        Long other$zoneId = other.getZoneId();
        return !(this$zoneId == null ? other$zoneId != null : !((Object)this$zoneId).equals(other$zoneId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClusterWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 0 : $description.hashCode());
        ClusterType $clusterType = this.getClusterType();
        result = result * 59 + ($clusterType == null ? 0 : ((Object)((Object)$clusterType)).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 0 : ((Object)((Object)$status)).hashCode());
        ClusterManagerType $clusterManagerType = this.getClusterManagerType();
        result = result * 59 + ($clusterManagerType == null ? 0 : ((Object)((Object)$clusterManagerType)).hashCode());
        Long $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 0 : ((Object)$zoneId).hashCode());
        return result;
    }
}

