/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.enums.SpaceUnit;
import com.flipkart.fdp.irm.webentities.ResourceProfileWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotNull;

@ApiModel(description="Object Representation of HDFS Profile.Its immutable.", parent=ResourceProfileWebEntity.class)
public class HdfsProfileWebEntity
extends ResourceProfileWebEntity {
    @JsonProperty
    @ApiModelProperty(value="Promised disk space for profile.", required=true)
    private long diskSpace;
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @NotNull
    @ApiModelProperty(value="Unit of disk space.", required=true, allowableValues="KB,MB,GB,TB,PB")
    private SpaceUnit spaceUnit;

    @JsonCreator
    public HdfsProfileWebEntity(@JsonProperty(value="description") String description, @JsonProperty(value="diskSpace") long diskSpace, @JsonProperty(value="spaceUnit") SpaceUnit spaceUnit) {
        this.description = description;
        this.diskSpace = diskSpace;
        this.spaceUnit = spaceUnit;
    }

    public long getDiskSpace() {
        return this.diskSpace;
    }

    public SpaceUnit getSpaceUnit() {
        return this.spaceUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HdfsProfileWebEntity)) {
            return false;
        }
        HdfsProfileWebEntity other = (HdfsProfileWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDiskSpace() != other.getDiskSpace()) {
            return false;
        }
        SpaceUnit this$spaceUnit = this.getSpaceUnit();
        SpaceUnit other$spaceUnit = other.getSpaceUnit();
        return !(this$spaceUnit == null ? other$spaceUnit != null : !((Object)((Object)this$spaceUnit)).equals((Object)other$spaceUnit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HdfsProfileWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $diskSpace = this.getDiskSpace();
        result = result * 59 + (int)($diskSpace >>> 32 ^ $diskSpace);
        SpaceUnit $spaceUnit = this.getSpaceUnit();
        result = result * 59 + ($spaceUnit == null ? 0 : ((Object)((Object)$spaceUnit)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HdfsProfileWebEntity(super=" + super.toString() + ", diskSpace=" + this.getDiskSpace() + ", spaceUnit=" + (Object)((Object)this.getSpaceUnit()) + ")";
    }
}

