/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Min;

@ApiModel(description="Object representing the hdfs quota", value="HdfsQuotaWebEntity", parent=QuotaWebEntity.class)
public class HdfsQuotaWebEntity
extends QuotaWebEntity {
    @Min(value=0x100000L)
    @JsonProperty
    @ApiModelProperty(value="Amount of space in bytes allocated/reserved")
    private long diskSpace;

    @JsonCreator
    public HdfsQuotaWebEntity(@JsonProperty(value="diskSpace") long diskSpace) {
        this.diskSpace = diskSpace;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HdfsQuotaWebEntity)) {
            return false;
        }
        HdfsQuotaWebEntity other = (HdfsQuotaWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getDiskSpace() == other.getDiskSpace();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HdfsQuotaWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $diskSpace = this.getDiskSpace();
        result = result * 59 + (int)($diskSpace >>> 32 ^ $diskSpace);
        return result;
    }

    @Override
    public String toString() {
        return "HdfsQuotaWebEntity(super=" + super.toString() + ", diskSpace=" + this.getDiskSpace() + ")";
    }

    public long getDiskSpace() {
        return this.diskSpace;
    }
}

