/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Object representing the kafka quota", value="KafkaQuotaWebEntity", parent=QuotaWebEntity.class)
public class KafkaQuotaWebEntity
extends QuotaWebEntity {
    @JsonProperty
    @ApiModelProperty(value="Amount of space in bytes allocated/reserved")
    private long diskSpace;
    @JsonProperty
    @ApiModelProperty(value="Number of partitions allocated/reserved")
    private long partitionsCount;
    @JsonProperty
    @ApiModelProperty(value="Reserved/Allocated throughput i.e requests per second")
    private long requestsCount;

    @JsonCreator
    public KafkaQuotaWebEntity(@JsonProperty(value="diskSpace") long diskSpace, @JsonProperty(value="partitionsCount") long partitionsCount, @JsonProperty(value="requestsCount") long requestsCount) {
        this.diskSpace = diskSpace;
        this.partitionsCount = partitionsCount;
        this.requestsCount = requestsCount;
    }

    public long getDiskSpace() {
        return this.diskSpace;
    }

    public long getPartitionsCount() {
        return this.partitionsCount;
    }

    public long getRequestsCount() {
        return this.requestsCount;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaQuotaWebEntity)) {
            return false;
        }
        KafkaQuotaWebEntity other = (KafkaQuotaWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDiskSpace() != other.getDiskSpace()) {
            return false;
        }
        if (this.getPartitionsCount() != other.getPartitionsCount()) {
            return false;
        }
        return this.getRequestsCount() == other.getRequestsCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaQuotaWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $diskSpace = this.getDiskSpace();
        result = result * 59 + (int)($diskSpace >>> 32 ^ $diskSpace);
        long $partitionsCount = this.getPartitionsCount();
        result = result * 59 + (int)($partitionsCount >>> 32 ^ $partitionsCount);
        long $requestsCount = this.getRequestsCount();
        result = result * 59 + (int)($requestsCount >>> 32 ^ $requestsCount);
        return result;
    }

    @Override
    public String toString() {
        return "KafkaQuotaWebEntity(super=" + super.toString() + ", diskSpace=" + this.getDiskSpace() + ", partitionsCount=" + this.getPartitionsCount() + ", requestsCount=" + this.getRequestsCount() + ")";
    }
}

