/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.enums.AccountType;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.webentities.BaseWebEntity;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@ApiModel(description="Object representation of reserved quota.")
public class QuotaReservationWebEntity
extends BaseWebEntity {
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of resource eg.HDFS", required=true, allowableValues="HDFS,KAFKA,YARN")
    private ResourceType resourceType;
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Account type eg. Org or Namespace.", required=true, allowableValues="ORG,NAMESPACE")
    private AccountType accountType;
    @JsonProperty
    @ApiModelProperty(value="Unique name of cluster.", required=true)
    private Long clusterId;
    @JsonProperty
    @ApiModelProperty(value="Unique identifier of Resource Quota", required=true)
    private QuotaWebEntity quota;
    @JsonProperty
    @ApiModelProperty(value="Unique name of a org for which this quota has been reserved.", required=true)
    private String orgName;
    @JsonProperty
    @ApiModelProperty(value="Unique name of a namespace for which this quota has been reserved.")
    private String namespaceName;

    public QuotaReservationWebEntity(ResourceType resourceType, AccountType accountType, Long clusterId, QuotaWebEntity quota, String orgName) {
        this.resourceType = resourceType;
        this.accountType = accountType;
        this.clusterId = clusterId;
        this.quota = quota;
        this.orgName = orgName;
    }

    @JsonCreator
    public QuotaReservationWebEntity(@JsonProperty(value="resourceType") ResourceType resourceType, @JsonProperty(value="clusterId") Long clusterId, @JsonProperty(value="quota") QuotaWebEntity quota) {
        this.resourceType = resourceType;
        this.clusterId = clusterId;
        this.quota = quota;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public QuotaWebEntity getQuota() {
        return this.quota;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotaReservationWebEntity)) {
            return false;
        }
        QuotaReservationWebEntity other = (QuotaReservationWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceType this$resourceType = this.getResourceType();
        ResourceType other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        AccountType this$accountType = this.getAccountType();
        AccountType other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)((Object)this$accountType)).equals((Object)other$accountType)) {
            return false;
        }
        Long this$clusterId = this.getClusterId();
        Long other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !((Object)this$clusterId).equals(other$clusterId)) {
            return false;
        }
        QuotaWebEntity this$quota = this.getQuota();
        QuotaWebEntity other$quota = other.getQuota();
        if (this$quota == null ? other$quota != null : !((Object)this$quota).equals(other$quota)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$namespaceName = this.getNamespaceName();
        String other$namespaceName = other.getNamespaceName();
        return !(this$namespaceName == null ? other$namespaceName != null : !this$namespaceName.equals(other$namespaceName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QuotaReservationWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceType $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 0 : ((Object)((Object)$resourceType)).hashCode());
        AccountType $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 0 : ((Object)((Object)$accountType)).hashCode());
        Long $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 0 : ((Object)$clusterId).hashCode());
        QuotaWebEntity $quota = this.getQuota();
        result = result * 59 + ($quota == null ? 0 : ((Object)$quota).hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 0 : $orgName.hashCode());
        String $namespaceName = this.getNamespaceName();
        result = result * 59 + ($namespaceName == null ? 0 : $namespaceName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QuotaReservationWebEntity(resourceType=" + (Object)((Object)this.getResourceType()) + ", accountType=" + (Object)((Object)this.getAccountType()) + ", clusterId=" + this.getClusterId() + ", quota=" + this.getQuota() + ", orgName=" + this.getOrgName() + ", namespaceName=" + this.getNamespaceName() + ")";
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }
}

