/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.webentities.BaseWebEntity;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotNull;

@ApiModel(description="Object representation of a resource.")
public class ResourceWebEntity
extends BaseWebEntity {
    @JsonProperty
    @ApiModelProperty(value="Token of a resource. eg, path in hdfs, queue in yarn etc, autogenerated", required=false, hidden=true)
    private String token;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Unique name of a cluster.", required=true)
    private Long clusterId;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Unique name of namespace.", required=true)
    private String namespaceName;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Unique name of org.", required=true)
    private String orgName;
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @NotNull
    @ApiModelProperty(value="Type of resource eg.HDFS", required=true, allowableValues="HDFS,KAFKA,YARN,GCS")
    private ResourceType resourceType;
    @JsonProperty
    @NotNull
    @ApiModelProperty(value="Description of a resource.", required=true)
    private String description;
    @JsonProperty
    @ApiModelProperty(value="Unique identifier of resource quota.", required=false)
    private QuotaWebEntity quota;

    @JsonCreator
    public ResourceWebEntity(@JsonProperty(value="clusterId") Long clusterId, @JsonProperty(value="namespaceName") String namespaceName, @JsonProperty(value="orgName") String orgName, @JsonProperty(value="resourceType") ResourceType resourceType, @JsonProperty(value="description") String description) {
        this.clusterId = clusterId;
        this.namespaceName = namespaceName;
        this.orgName = orgName;
        this.resourceType = resourceType;
        this.description = description;
    }

    public ResourceWebEntity(Long clusterId, String namespaceName, String orgName, ResourceType resourceType, String description, QuotaWebEntity quota) {
        this.clusterId = clusterId;
        this.namespaceName = namespaceName;
        this.orgName = orgName;
        this.resourceType = resourceType;
        this.description = description;
        this.quota = quota;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getDescription() {
        return this.description;
    }

    public QuotaWebEntity getQuota() {
        return this.quota;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceWebEntity)) {
            return false;
        }
        ResourceWebEntity other = (ResourceWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Long this$clusterId = this.getClusterId();
        Long other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !((Object)this$clusterId).equals(other$clusterId)) {
            return false;
        }
        String this$namespaceName = this.getNamespaceName();
        String other$namespaceName = other.getNamespaceName();
        if (this$namespaceName == null ? other$namespaceName != null : !this$namespaceName.equals(other$namespaceName)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        ResourceType this$resourceType = this.getResourceType();
        ResourceType other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        QuotaWebEntity this$quota = this.getQuota();
        QuotaWebEntity other$quota = other.getQuota();
        return !(this$quota == null ? other$quota != null : !((Object)this$quota).equals(other$quota));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ResourceWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 0 : $token.hashCode());
        Long $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 0 : ((Object)$clusterId).hashCode());
        String $namespaceName = this.getNamespaceName();
        result = result * 59 + ($namespaceName == null ? 0 : $namespaceName.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 0 : $orgName.hashCode());
        ResourceType $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 0 : ((Object)((Object)$resourceType)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 0 : $description.hashCode());
        QuotaWebEntity $quota = this.getQuota();
        result = result * 59 + ($quota == null ? 0 : ((Object)$quota).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ResourceWebEntity(token=" + this.getToken() + ", clusterId=" + this.getClusterId() + ", namespaceName=" + this.getNamespaceName() + ", orgName=" + this.getOrgName() + ", resourceType=" + (Object)((Object)this.getResourceType()) + ", description=" + this.getDescription() + ", quota=" + this.getQuota() + ")";
    }

    public void setQuota(QuotaWebEntity quota) {
        this.quota = quota;
    }
}

