/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.enums.MemoryUnit;
import com.flipkart.fdp.irm.webentities.ResourceProfileWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotNull;

@ApiModel(description="Object representation of YARN Profile. Its immutable.", parent=ResourceProfileWebEntity.class)
public class YarnProfileWebEntity
extends ResourceProfileWebEntity {
    @JsonProperty
    @ApiModelProperty(value="Total count of cpus promised.", required=true)
    private int cpuCount;
    @JsonProperty
    @ApiModelProperty(value="Promised memory allocation for this profile.", required=true)
    private int memory;
    @JsonProperty
    @Enumerated(value=EnumType.STRING)
    @NotNull
    @ApiModelProperty(value="Default unit of memory allocation.", required=true)
    private MemoryUnit memoryUnit;

    @JsonCreator
    public YarnProfileWebEntity(@JsonProperty(value="description") String description, @JsonProperty(value="cpuCount") int cpuCount, @JsonProperty(value="memory") int memory, @JsonProperty(value="memoryUnit") MemoryUnit memoryUnit) {
        this.description = description;
        this.cpuCount = cpuCount;
        this.memory = memory;
        this.memoryUnit = memoryUnit;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public int getMemory() {
        return this.memory;
    }

    public MemoryUnit getMemoryUnit() {
        return this.memoryUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YarnProfileWebEntity)) {
            return false;
        }
        YarnProfileWebEntity other = (YarnProfileWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCpuCount() != other.getCpuCount()) {
            return false;
        }
        if (this.getMemory() != other.getMemory()) {
            return false;
        }
        MemoryUnit this$memoryUnit = this.getMemoryUnit();
        MemoryUnit other$memoryUnit = other.getMemoryUnit();
        return !(this$memoryUnit == null ? other$memoryUnit != null : !((Object)((Object)this$memoryUnit)).equals((Object)other$memoryUnit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof YarnProfileWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getCpuCount();
        result = result * 59 + this.getMemory();
        MemoryUnit $memoryUnit = this.getMemoryUnit();
        result = result * 59 + ($memoryUnit == null ? 0 : ((Object)((Object)$memoryUnit)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "YarnProfileWebEntity(super=" + super.toString() + ", cpuCount=" + this.getCpuCount() + ", memory=" + this.getMemory() + ", memoryUnit=" + (Object)((Object)this.getMemoryUnit()) + ")";
    }
}

