/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.webentities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Object representing the yarn quota", value="YarnQuotaWebEntity", parent=QuotaWebEntity.class)
public class YarnQuotaWebEntity
extends QuotaWebEntity {
    @JsonProperty
    @ApiModelProperty(value="Minimum Memory reserved/allocated in bytes in a quota.")
    private long minMemory;
    @JsonProperty
    @ApiModelProperty(value="Minimum Number of cpu's allocated/reserved in a quota.")
    private long minCpuCount;
    @JsonProperty
    @ApiModelProperty(value="Maximum Memory reserved/allocated in bytes in a quota., maximum-minimum will be shared if unused")
    private long maxMemory;
    @JsonProperty
    @ApiModelProperty(value="Maximum Number of cpu's allocated/reserved in a quota. maximum-minimum will be shared if unused")
    private long maxCpuCount;

    @JsonCreator
    public YarnQuotaWebEntity(@JsonProperty(value="minMemory") long minMemory, @JsonProperty(value="minCpuCount") long minCpuCount, @JsonProperty(value="maxMemory") long maxMemory, @JsonProperty(value="maxCpuCount") long maxCpuCount) {
        this.minMemory = minMemory;
        this.minCpuCount = minCpuCount;
        this.maxMemory = maxMemory;
        this.maxCpuCount = maxCpuCount;
    }

    public long getMinMemory() {
        return this.minMemory;
    }

    public long getMinCpuCount() {
        return this.minCpuCount;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getMaxCpuCount() {
        return this.maxCpuCount;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YarnQuotaWebEntity)) {
            return false;
        }
        YarnQuotaWebEntity other = (YarnQuotaWebEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinMemory() != other.getMinMemory()) {
            return false;
        }
        if (this.getMinCpuCount() != other.getMinCpuCount()) {
            return false;
        }
        if (this.getMaxMemory() != other.getMaxMemory()) {
            return false;
        }
        return this.getMaxCpuCount() == other.getMaxCpuCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof YarnQuotaWebEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minMemory = this.getMinMemory();
        result = result * 59 + (int)($minMemory >>> 32 ^ $minMemory);
        long $minCpuCount = this.getMinCpuCount();
        result = result * 59 + (int)($minCpuCount >>> 32 ^ $minCpuCount);
        long $maxMemory = this.getMaxMemory();
        result = result * 59 + (int)($maxMemory >>> 32 ^ $maxMemory);
        long $maxCpuCount = this.getMaxCpuCount();
        result = result * 59 + (int)($maxCpuCount >>> 32 ^ $maxCpuCount);
        return result;
    }

    @Override
    public String toString() {
        return "YarnQuotaWebEntity(minMemory=" + this.getMinMemory() + ", minCpuCount=" + this.getMinCpuCount() + ", maxMemory=" + this.getMaxMemory() + ", maxCpuCount=" + this.getMaxCpuCount() + ")";
    }
}

