/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StateMachineDefinition {
    private String name;
    private Long version;
    private String description;
    private Set<StateDefinition> states;
    private Set<EventData> eventData;
    private String correlationId;

    StateMachineDefinition() {
        this(null, null, null, Collections.emptySet(), Collections.emptySet(), null);
    }

    public StateMachineDefinition(String description, String name, Long version, Set<StateDefinition> stateDefinitions, Set<EventData> eventData, String correlationId) {
        this.description = description;
        this.name = name;
        this.states = stateDefinitions;
        this.version = version;
        this.eventData = eventData;
        this.correlationId = correlationId;
    }

    public void addState(StateDefinition stateDefinition) {
        this.states.add(stateDefinition);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<StateDefinition> getStates() {
        return this.states;
    }

    public void setStates(Set<StateDefinition> states) {
        this.states = states;
    }

    public Set<EventData> getEventData() {
        return this.eventData;
    }

    public void setEventData(Set<EventData> eventData) {
        this.eventData = eventData;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @JsonIgnore
    public Map<EventDefinition, EventData> getEventDataMap() {
        HashMap<EventDefinition, EventData> eventDataMap = new HashMap<EventDefinition, EventData>();
        for (StateDefinition aState : this.states) {
            List<EventDefinition> dependenciesForCurrentState = aState.getDependencies();
            for (EventDefinition anEventDefinition : dependenciesForCurrentState) {
                eventDataMap.putIfAbsent(anEventDefinition, this.retrieveEventDataFor(anEventDefinition));
            }
            EventDefinition outputEventDefinition = aState.getOutputEvent();
            if (outputEventDefinition == null) continue;
            eventDataMap.put(outputEventDefinition, this.retrieveEventDataFor(outputEventDefinition));
        }
        return eventDataMap;
    }

    private EventData retrieveEventDataFor(EventDefinition anEventDefinition) {
        for (EventData someData : this.eventData) {
            if (!someData.isFor(anEventDefinition)) continue;
            return someData;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMachineDefinition that = (StateMachineDefinition)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.states.equals(that.states)) {
            return false;
        }
        return this.eventData.equals(that.eventData);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.states.hashCode();
        result = 31 * result + this.eventData.hashCode();
        return result;
    }

    public String toString() {
        return "StateMachineDefinition{description='" + this.description + '\'' + ", name='" + this.name + '\'' + ", version=" + this.version + ", states=" + this.states + ", eventData=" + this.eventData + '}';
    }

    public void addEventDatas(EventData[] events) {
        Collections.addAll(this.eventData, events);
    }
}

