/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.flipkart.flux.api.EventDefinition;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventData
implements Serializable {
    private String name;
    private String type;
    private String data;
    private String eventSource;
    private Boolean isCancelled;

    EventData() {
    }

    public EventData(String name, String type, String data, String eventSource) {
        this(name, type, data, eventSource, false);
    }

    public EventData(String name, String type, String data, String eventSource, Boolean isCancelled) {
        this.name = name;
        this.type = type;
        this.data = data;
        this.eventSource = eventSource;
        this.isCancelled = isCancelled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public Boolean getCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(Boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventData eventData = (EventData)o;
        if (!this.name.equals(eventData.name)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(eventData.type) : eventData.type != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(eventData.data) : eventData.data != null) {
            return false;
        }
        if (this.eventSource != null ? !this.eventSource.equals(eventData.eventSource) : eventData.eventSource != null) {
            return false;
        }
        return this.isCancelled != null ? this.isCancelled.equals(eventData.isCancelled) : eventData.isCancelled == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
        result = 31 * result + (this.isCancelled != null ? this.isCancelled.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventData{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", data='" + this.data + '\'' + ", eventSource='" + this.eventSource + '\'' + ", isCancelled=" + this.isCancelled + '}';
    }

    @JsonIgnore
    public boolean isFor(EventDefinition eventDefinition) {
        return this.name.equals(eventDefinition.getName()) && this.type.equals(eventDefinition.getType());
    }
}

