/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.flipkart.flux.api.EventDefinition;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VersionedEventData
implements Serializable {
    private String name;
    private String type;
    private String data;
    private String eventSource;
    private Boolean isCancelled;
    private Long executionVersion;

    VersionedEventData() {
    }

    public VersionedEventData(String name, String type, String data, String eventSource) {
        this(name, type, data, eventSource, false, 0L);
    }

    public VersionedEventData(String name, String type, String data, String eventSource, Long executionVersion) {
        this(name, type, data, eventSource, false, executionVersion);
    }

    public VersionedEventData(String name, String type, String data, String eventSource, Boolean isCancelled) {
        this(name, type, data, eventSource, isCancelled, 0L);
    }

    public VersionedEventData(String name, String type, String data, String eventSource, Boolean isCancelled, Long executionVersion) {
        this.name = name;
        this.type = type;
        this.data = data;
        this.eventSource = eventSource;
        this.isCancelled = isCancelled;
        this.executionVersion = executionVersion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public Boolean getCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(Boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public Long getExecutionVersion() {
        return this.executionVersion;
    }

    public void setExecutionVersion(Long executionVersion) {
        this.executionVersion = executionVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedEventData versionedEventData = (VersionedEventData)o;
        if (!this.name.equals(versionedEventData.name)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(versionedEventData.type) : versionedEventData.type != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(versionedEventData.data) : versionedEventData.data != null) {
            return false;
        }
        if (this.eventSource != null ? !this.eventSource.equals(versionedEventData.eventSource) : versionedEventData.eventSource != null) {
            return false;
        }
        if (this.executionVersion != null ? !this.executionVersion.equals(versionedEventData.executionVersion) : versionedEventData.executionVersion != null) {
            return false;
        }
        return this.isCancelled != null ? this.isCancelled.equals(versionedEventData.isCancelled) : versionedEventData.isCancelled == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
        result = 31 * result + (this.executionVersion != null ? this.executionVersion.hashCode() : 0);
        result = 31 * result + (this.isCancelled != null ? this.isCancelled.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VersionedEventData{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", data='" + this.data + '\'' + ", eventSource='" + this.eventSource + '\'' + ", executionVersion=" + this.executionVersion + ", isCancelled=" + this.isCancelled + '}';
    }

    @JsonIgnore
    public boolean isFor(EventDefinition eventDefinition) {
        return this.name.equals(eventDefinition.getName()) && this.type.equals(eventDefinition.getType());
    }
}

