/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.registry;

import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.registry.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExecutableImpl
implements Executable {
    private final Method toInvoke;
    private final Object singletonMethodOwner;
    private final long timeout;

    public ExecutableImpl(Object singletonMethodOwner, Method toInvoke, long timeout) {
        this.singletonMethodOwner = singletonMethodOwner;
        this.toInvoke = toInvoke;
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableImpl that = (ExecutableImpl)o;
        if (this.timeout != that.timeout) {
            return false;
        }
        if (!this.toInvoke.equals(that.toInvoke)) {
            return false;
        }
        return this.singletonMethodOwner.equals(that.singletonMethodOwner);
    }

    public int hashCode() {
        int result = this.toInvoke.hashCode();
        result = 31 * result + this.singletonMethodOwner.hashCode();
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        return result;
    }

    public String toString() {
        return "Executable{singletonMethodOwner=" + this.singletonMethodOwner + ", toInvoke=" + this.toInvoke + '}';
    }

    @Override
    public String getName() {
        return new MethodId(this.toInvoke).getMethodName();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Object execute(Object[] parameters) {
        try {
            return this.toInvoke.invoke(this.singletonMethodOwner, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.toInvoke.getParameterTypes();
    }
}

