/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.runtime;

import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.client.model.Event;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;

public class LocalContext {
    private ThreadLocal<StateMachineDefinition> stateMachineDefinition;
    private ThreadLocal<MutableInt> tlUniqueEventCount;
    private ThreadLocal<IdentityHashMap<Event, String>> eventNames;

    public LocalContext() {
        this(new ThreadLocal<StateMachineDefinition>(), new ThreadLocal<MutableInt>(), new ThreadLocal<IdentityHashMap<Event, String>>());
    }

    LocalContext(ThreadLocal<StateMachineDefinition> stateMachineDefinition, ThreadLocal<MutableInt> tlUniqueEventCount, ThreadLocal<IdentityHashMap<Event, String>> eventNames) {
        this.stateMachineDefinition = stateMachineDefinition;
        this.tlUniqueEventCount = tlUniqueEventCount;
        this.eventNames = eventNames;
    }

    public void registerNew(String methodIdentifier, long version, String description) {
        if (this.stateMachineDefinition.get() != null) {
            throw new IllegalStateException("A single thread cannot execute more than one workflow");
        }
        this.stateMachineDefinition.set(new StateMachineDefinition(description, methodIdentifier, Long.valueOf(version), new HashSet(), new HashSet()));
        this.tlUniqueEventCount.set(new MutableInt(0));
        this.eventNames.set(new IdentityHashMap());
    }

    public void registerNewState(Long version, String name, String description, String hookIdentifier, String taskIdentifier, Long retryCount, Long timeout, Set<EventDefinition> dependencySet, EventDefinition outputEvent) {
        StateDefinition stateDefinition = new StateDefinition(version, name, description, hookIdentifier, taskIdentifier, hookIdentifier, retryCount, timeout, dependencySet, outputEvent);
        this.stateMachineDefinition.get().addState(stateDefinition);
    }

    public void reset() {
        this.stateMachineDefinition.remove();
        this.tlUniqueEventCount.remove();
        this.eventNames.remove();
    }

    public StateMachineDefinition getStateMachineDef() {
        return this.stateMachineDefinition.get();
    }

    public boolean isWorkflowInterception() {
        return this.getStateMachineDef() != null;
    }

    public void addEvents(EventData ... events) {
        this.stateMachineDefinition.get().addEventDatas(events);
    }

    public String generateEventName(Event event) {
        IdentityHashMap<Event, String> eventNamesMap = this.eventNames.get();
        if (!eventNamesMap.containsKey(event)) {
            eventNamesMap.put(event, this.generateName(event));
        }
        return eventNamesMap.get(event);
    }

    private String generateName(Event event) {
        int currentEventNumber = this.tlUniqueEventCount.get().intValue();
        this.tlUniqueEventCount.get().increment();
        return event.name() + currentEventNumber;
    }
}

