/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.internal.$transform.impl;

import com.flipkart.flux.internal.$asm.Type;
import com.flipkart.flux.internal.$core.CodeEmitter;
import com.flipkart.flux.internal.$core.Constants;
import com.flipkart.flux.internal.$core.MethodInfo;
import com.flipkart.flux.internal.$core.ReflectUtils;
import com.flipkart.flux.internal.$core.Signature;
import com.flipkart.flux.internal.$transform.ClassEmitterTransformer;
import java.lang.reflect.Method;

public class AddInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddInitTransformer(Method method) {
        this.info = ReflectUtils.getMethodInfo(method);
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constants.TYPE_OBJECT) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        CodeEmitter emitter = super.begin_method(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(emitter){

                public void visitInsn(int opcode) {
                    if (opcode == 177) {
                        this.load_this();
                        this.invoke(AddInitTransformer.this.info);
                    }
                    super.visitInsn(opcode);
                }
            };
        }
        return emitter;
    }
}

