/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.intercept;

import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.client.intercept.IllegalInvocationException;
import com.flipkart.flux.client.intercept.IllegalSignatureException;
import com.flipkart.flux.client.intercept.Intercepted;
import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.intercept.ProxyEventCallbackFilter;
import com.flipkart.flux.client.intercept.ReturnGivenStringCallback;
import com.flipkart.flux.client.model.Event;
import com.flipkart.flux.client.model.ExternalEvent;
import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.registry.ExecutableImpl;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.client.runtime.LocalContext;
import com.flipkart.flux.internal.$proxy.Enhancer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TaskInterceptor
implements MethodInterceptor {
    @Inject
    private LocalContext localContext;
    @Inject
    private ExecutableRegistry executableRegistry;

    public TaskInterceptor() {
    }

    TaskInterceptor(LocalContext localContext, ExecutableRegistry executableRegistry) {
        this.localContext = localContext;
        this.executableRegistry = executableRegistry;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.checkForBadSignatures(invocation);
        if (!this.localContext.isWorkflowInterception()) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        Task taskAnnotation = ((Task[])method.getAnnotationsByType(Task.class))[0];
        String taskIdentifier = this.generateTaskIdentifier(method);
        Set<EventDefinition> dependencySet = this.generateDependencySet(invocation.getArguments(), method.getParameterAnnotations(), method.getParameterTypes());
        Object proxyReturnObject = this.createProxyReturnObject(method);
        EventDefinition outputEventDefintion = this.generateOutputEventDefintion(proxyReturnObject);
        this.localContext.registerNewState(taskAnnotation.version(), this.generateStateIdentifier(method), null, null, taskIdentifier, taskAnnotation.retries(), taskAnnotation.timeout(), dependencySet, outputEventDefintion);
        this.executableRegistry.registerTask(taskIdentifier, new ExecutableImpl(invocation.getThis(), invocation.getMethod(), taskAnnotation.timeout()));
        return proxyReturnObject;
    }

    private EventDefinition generateOutputEventDefintion(Object proxyReturnObject) {
        if (proxyReturnObject == null) {
            return null;
        }
        String eventName = ((Event)proxyReturnObject).name();
        String eventType = ((Intercepted)proxyReturnObject).getRealClassName();
        return new EventDefinition(eventName, eventType);
    }

    private Object createProxyReturnObject(final Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        String eventName = this.localContext.generateEventName(new Event(){

            @Override
            public String name() {
                return method.getReturnType().getName();
            }
        });
        final ReturnGivenStringCallback eventNameCallback = new ReturnGivenStringCallback(eventName);
        final ReturnGivenStringCallback realClassNameCallback = new ReturnGivenStringCallback(method.getReturnType().getName());
        ProxyEventCallbackFilter filter = new ProxyEventCallbackFilter(method.getReturnType(), new Class[]{Intercepted.class}){

            @Override
            protected ReturnGivenStringCallback getRealClassName() {
                return realClassNameCallback;
            }

            @Override
            public ReturnGivenStringCallback getNameCallback() {
                return eventNameCallback;
            }
        };
        return Enhancer.create(method.getReturnType(), new Class[]{Intercepted.class}, filter, filter.getCallbacks());
    }

    private void checkForBadSignatures(MethodInvocation invocation) {
        Class<?>[] parameterTypes;
        Method method = invocation.getMethod();
        for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            if (Event.class.isAssignableFrom(parameterType)) continue;
            throw new IllegalSignatureException(new MethodId(method), "Task parameters need to implement the com.flipkart.flux.client.model.Event interface. Found parameter of type" + parameterType + " which does not");
        }
    }

    private Set<EventDefinition> generateDependencySet(Object[] arguments, Annotation[][] parameterAnnotations, Class<?>[] parameterTypes) {
        HashSet<EventDefinition> eventDefinitions = new HashSet<EventDefinition>();
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            ExternalEvent externalEventAnnotation = this.checkForExternalEventAnnotation(parameterAnnotations[i]);
            if (externalEventAnnotation != null) {
                if (argument != null) {
                    throw new IllegalInvocationException("cannot pass" + argument + " as the parameter is marked an external event");
                }
                EventDefinition definition = new EventDefinition(externalEventAnnotation.value(), parameterTypes[i].getName());
                EventDefinition existingDefinition = this.localContext.checkExistingDefinition(definition);
                if (existingDefinition != null) {
                    eventDefinitions.add(existingDefinition);
                    continue;
                }
                eventDefinitions.add(definition);
                continue;
            }
            if (argument instanceof Intercepted) {
                eventDefinitions.add(new EventDefinition(((Event)argument).name(), ((Intercepted)argument).getRealClassName()));
                continue;
            }
            eventDefinitions.add(new EventDefinition(this.localContext.generateEventName((Event)argument), argument.getClass().getName()));
        }
        return eventDefinitions;
    }

    private ExternalEvent checkForExternalEventAnnotation(Annotation[] givenParameterAnnotations) {
        for (Annotation annotation : givenParameterAnnotations) {
            if (!(annotation instanceof ExternalEvent)) continue;
            return (ExternalEvent)annotation;
        }
        return null;
    }

    private String generateStateIdentifier(Method method) {
        return method.getName();
    }

    private String generateTaskIdentifier(Method method) {
        return new MethodId(method).toString();
    }
}

