/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.intercept;

import com.flipkart.flux.client.intercept.MalformedIdentifierException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class MethodId {
    public static final String UNDERSCORE = "_";
    private String className;
    private String methodName;
    private Class<?>[] parameterTypes;
    private String returnType;

    public static MethodId fromIdentifier(String identifier) throws ClassNotFoundException {
        String[] splitIdentifier = identifier.split(UNDERSCORE);
        MethodId generatedMethodId = new MethodId();
        try {
            generatedMethodId.className = splitIdentifier[0];
            generatedMethodId.methodName = splitIdentifier[1];
            generatedMethodId.returnType = splitIdentifier[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MalformedIdentifierException("Malformed identifier : " + identifier);
        }
        if (splitIdentifier.length > 3) {
            generatedMethodId.parameterTypes = new Class[splitIdentifier.length - 3];
            for (int i = 3; i < splitIdentifier.length; ++i) {
                generatedMethodId.parameterTypes[splitIdentifier.length - i - 1] = Class.forName(splitIdentifier[i]);
            }
        }
        return generatedMethodId;
    }

    private MethodId() {
    }

    public MethodId(Method method) {
        this.className = method.getDeclaringClass().getCanonicalName();
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.returnType = method.getReturnType().getCanonicalName();
    }

    public String getPrefix() {
        return this.className + UNDERSCORE + this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodId methodId = (MethodId)o;
        if (this.className != null ? !this.className.equals(methodId.className) : methodId.className != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(methodId.methodName) : methodId.methodName != null) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, methodId.parameterTypes)) {
            return false;
        }
        return !(this.returnType == null ? methodId.returnType != null : !this.returnType.equals(methodId.returnType));
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.parameterTypes != null ? Arrays.hashCode(this.parameterTypes) : 0);
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getPrefix());
        stringBuilder.append(UNDERSCORE);
        stringBuilder.append(this.returnType);
        for (Class<?> parameterType : this.parameterTypes) {
            stringBuilder.append(UNDERSCORE);
            stringBuilder.append(parameterType.getName());
        }
        return stringBuilder.toString();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }
}

