/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.registry;

import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.intercept.UnknownIdentifierException;
import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.client.registry.ExecutableImpl;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LocalExecutableRegistryImpl
implements ExecutableRegistry {
    private final Map<String, Executable> identifierToMethodMap;
    private final Injector injector;

    @Inject
    public LocalExecutableRegistryImpl(Injector injector) {
        this(new ConcurrentHashMap<String, Executable>(), injector);
    }

    public LocalExecutableRegistryImpl(Map<String, Executable> identifierToMethodMap, Injector injector) {
        this.identifierToMethodMap = identifierToMethodMap;
        this.injector = injector;
    }

    @Override
    public Executable getTask(String taskIdentifier) {
        Executable cachedExecutable = this.identifierToMethodMap.get(taskIdentifier);
        if (cachedExecutable == null) {
            try {
                MethodId methodId = MethodId.fromIdentifier(taskIdentifier.substring(0, taskIdentifier.lastIndexOf(95)));
                Class<?> clazz = Class.forName(methodId.getClassName());
                Object classInstance = this.injector.getInstance(clazz);
                Method methodToInvoke = clazz.getDeclaredMethod(methodId.getMethodName(), methodId.getParameterTypes());
                Task taskAnnotation = ((Task[])methodToInvoke.getAnnotationsByType(Task.class))[0];
                return new ExecutableImpl(classInstance, methodToInvoke, taskAnnotation.timeout());
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new UnknownIdentifierException("Could not load method corresponding to the given task identifier:" + taskIdentifier);
            }
        }
        return cachedExecutable;
    }

    @Override
    public Method getHook(String hookIdentifier) {
        return null;
    }

    @Override
    public void registerTask(String taskIdentifier, Executable method) {
        this.identifierToMethodMap.put(taskIdentifier, method);
    }

    @Override
    public void unregisterTask(String taskIdentifier) {
        this.identifierToMethodMap.remove(taskIdentifier);
    }
}

