/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client;

import com.codahale.metrics.SharedMetricRegistries;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.client.config.FluxClientConfiguration;
import com.flipkart.flux.client.guice.annotation.IsolatedEnv;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.client.registry.LocalExecutableRegistryImpl;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.client.runtime.FluxRuntimeConnectorHttpImpl;
import com.flipkart.flux.client.runtime.LocalContext;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import javax.inject.Singleton;

public class FluxClientComponentModule
extends AbstractModule {
    protected void configure() {
        this.bind(ExecutableRegistry.class).annotatedWith(IsolatedEnv.class).to(LocalExecutableRegistryImpl.class);
    }

    @Provides
    @Singleton
    public FluxRuntimeConnector provideFluxRuntimeConnector(FluxClientConfiguration configuration, ObjectMapper objectMapper) {
        String fluxRuntimeUrl = System.getProperty("flux.runtimeUrl");
        if (fluxRuntimeUrl == null) {
            fluxRuntimeUrl = configuration.getFluxRuntimeUrl();
        }
        if (!fluxRuntimeUrl.endsWith("/")) {
            fluxRuntimeUrl = fluxRuntimeUrl + "/";
        }
        return new FluxRuntimeConnectorHttpImpl(configuration.getConnectionTimeout(), configuration.getSocketTimeout(), fluxRuntimeUrl + "api/machines", objectMapper, SharedMetricRegistries.getOrCreate((String)"mainMetricRegistry"));
    }

    @Provides
    @Singleton
    public LocalContext getLocalContext() {
        return new LocalContext();
    }
}

