/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.runtime;

import com.codahale.metrics.SharedMetricRegistries;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.client.config.FluxClientConfiguration;
import com.flipkart.flux.client.runtime.FluxRuntimeConnectorHttpImpl;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventProxyConnector
extends FluxRuntimeConnectorHttpImpl {
    public static Logger logger = LogManager.getLogger(EventProxyConnector.class);
    private static final String EXTERNAL = "external";

    @Inject
    public EventProxyConnector(@Named(value="eventProxyForMigration.endpoint") String endpoint, FluxClientConfiguration fluxClientConfiguration) {
        super(fluxClientConfiguration.getConnectionTimeout(), fluxClientConfiguration.getSocketTimeout(), endpoint, new ObjectMapper(), SharedMetricRegistries.getOrCreate((String)"mainMetricRegistry"));
    }

    @Override
    public void submitEvent(String name, Object data, String correlationId, String eventSource) {
        String eventType = data.getClass().getName();
        if (eventSource == null) {
            eventSource = EXTERNAL;
        }
        CloseableHttpResponse httpResponse = null;
        try {
            EventData eventData = new EventData(name, eventType, (String)data, eventSource);
            httpResponse = this.postOverHttp(eventData, "/" + correlationId + "/context/events?searchField=correlationId");
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void submitScheduledEvent(String name, Object data, String correlationId, String eventSource, Long triggerTime) {
        String eventType = data.getClass().getName();
        if (eventSource == null) {
            eventSource = EXTERNAL;
        }
        EventData eventData = new EventData(name, eventType, (String)data, eventSource);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = triggerTime != null ? this.postOverHttp(eventData, "/" + correlationId + "/context/events?searchField=correlationId&triggerTime=" + triggerTime) : this.postOverHttp(eventData, "/" + correlationId + "/context/events?searchField=correlationId");
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void submitReplayEvent(String name, Object data, String correlationId, String eventSource) {
        String eventType = data.getClass().getName();
        CloseableHttpResponse httpResponse = null;
        try {
            EventData eventData = new EventData(name, eventType, (String)data, eventSource);
            httpResponse = this.postOverHttp(eventData, "/" + correlationId + "/context/replayevent?searchField=correlationId");
        }
        catch (Exception e) {
            try {
                logger.error("Posting over http errored. Message: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }
}

