/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.runtime;

import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.client.intercept.IllegalInvocationException;
import com.flipkart.flux.client.model.Event;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableInt;

public class LocalContext {
    private ThreadLocal<StateMachineDefinition> stateMachineDefinition;
    private ThreadLocal<MutableInt> tlUniqueEventCount;
    private ThreadLocal<IdentityHashMap<Event, String>> eventNames;

    public LocalContext() {
        this(new ThreadLocal<StateMachineDefinition>(), new ThreadLocal<MutableInt>(), new ThreadLocal<IdentityHashMap<Event, String>>());
    }

    LocalContext(ThreadLocal<StateMachineDefinition> stateMachineDefinition, ThreadLocal<MutableInt> tlUniqueEventCount, ThreadLocal<IdentityHashMap<Event, String>> eventNames) {
        this.stateMachineDefinition = stateMachineDefinition;
        this.tlUniqueEventCount = tlUniqueEventCount;
        this.eventNames = eventNames;
    }

    public void registerNew(String workflowIdentifier, long version, String description, String correlationId, String clientElbId) {
        if (this.stateMachineDefinition.get() != null) {
            throw new IllegalStateException("A single thread cannot execute more than one workflow");
        }
        this.stateMachineDefinition.set(new StateMachineDefinition(description, workflowIdentifier, Long.valueOf(version), new HashSet(), new HashSet(), correlationId, clientElbId));
        this.tlUniqueEventCount.set(new MutableInt(0));
        this.eventNames.set(new IdentityHashMap());
    }

    public void registerNewState(Long version, String name, String description, String hookIdentifier, String taskIdentifier, Long retryCount, Long timeout, List<EventDefinition> dependencySet, EventDefinition outputEvent) {
        StateDefinition stateDefinition = new StateDefinition(version, name, description, hookIdentifier, taskIdentifier, hookIdentifier, retryCount, timeout, dependencySet, outputEvent);
        this.stateMachineDefinition.get().addState(stateDefinition);
    }

    public void registerNewState(Long version, String name, String description, String hookIdentifier, String taskIdentifier, Long retryCount, Long timeout, boolean isReplayable, List<EventDefinition> dependencySet, EventDefinition outputEvent, short replayableRetryCount) {
        StateDefinition stateDefinition = new StateDefinition(version, name, description, hookIdentifier, taskIdentifier, hookIdentifier, retryCount, timeout, dependencySet, outputEvent, isReplayable, replayableRetryCount);
        this.stateMachineDefinition.get().addState(stateDefinition);
    }

    public void reset() {
        this.stateMachineDefinition.remove();
        this.tlUniqueEventCount.remove();
        this.eventNames.remove();
    }

    public StateMachineDefinition getStateMachineDef() {
        return this.stateMachineDefinition.get();
    }

    public boolean isWorkflowInterception() {
        return this.getStateMachineDef() != null;
    }

    public void addEvents(EventData ... events) {
        this.stateMachineDefinition.get().addEventDatas(events);
    }

    public String generateEventName(Event event) {
        IdentityHashMap<Event, String> eventNamesMap = this.eventNames.get();
        if (!eventNamesMap.containsKey(event)) {
            eventNamesMap.put(event, this.generateName(event));
        }
        return eventNamesMap.get(event);
    }

    private String generateName(Event event) {
        int currentEventNumber = this.tlUniqueEventCount.get().intValue();
        this.tlUniqueEventCount.get().increment();
        return event.name() + currentEventNumber;
    }

    public EventDefinition checkExistingDefinition(EventDefinition givenDefinition) {
        StateMachineDefinition stateMachineDefinition = this.stateMachineDefinition.get();
        HashSet allDefinitions = new HashSet();
        stateMachineDefinition.getStates().stream().map(new Function<StateDefinition, Collection<EventDefinition>>(){

            @Override
            public Collection<EventDefinition> apply(StateDefinition stateDefinition) {
                return stateDefinition.getDependencies();
            }
        }).forEach(allDefinitions::addAll);
        Optional<EventDefinition> searchResult = allDefinitions.stream().filter(eventDefinition -> givenDefinition.getName().equals(eventDefinition.getName())).findFirst();
        if (!searchResult.isPresent()) {
            return null;
        }
        EventDefinition eventDefinitionWithMatchingName = searchResult.get();
        if (eventDefinitionWithMatchingName.getType().equals(givenDefinition.getType())) {
            return eventDefinitionWithMatchingName;
        }
        throw new IllegalInvocationException("Cannot invoke two parameters with the same name & different types!");
    }
}

