/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.intercept;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.client.config.FluxClientConfiguration;
import com.flipkart.flux.client.intercept.IllegalSignatureException;
import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.model.CorrelationId;
import com.flipkart.flux.client.model.Event;
import com.flipkart.flux.client.model.Workflow;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.client.runtime.LocalContext;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

@Singleton
public class WorkflowInterceptor
implements MethodInterceptor {
    @Inject
    private LocalContext localContext;
    @Inject
    private Provider<FluxRuntimeConnector> connectorProvider;
    @Inject
    private Provider<ObjectMapper> objectMapperProvider;
    @Inject
    private Provider<FluxClientConfiguration> fluxClientConfigurationProvider;

    public WorkflowInterceptor() {
    }

    @VisibleForTesting
    public WorkflowInterceptor(LocalContext localContext, Provider<FluxRuntimeConnector> connectorProvider, Provider<ObjectMapper> objectMapperProvider, Provider<FluxClientConfiguration> fluxClientConfigurationProvider) {
        this();
        this.localContext = localContext;
        this.connectorProvider = connectorProvider;
        this.objectMapperProvider = objectMapperProvider;
        this.fluxClientConfigurationProvider = fluxClientConfigurationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            String clientElbId = System.getProperty("flux.clientElbId");
            if (clientElbId == null) {
                clientElbId = ((FluxClientConfiguration)this.fluxClientConfigurationProvider.get()).getClientElbId();
            }
            Method method = invocation.getMethod();
            Workflow[] workFlowAnnotations = (Workflow[])method.getAnnotationsByType(Workflow.class);
            this.checkForBadSignatures(invocation);
            String correlationId = this.checkForCorrelationId(invocation.getArguments());
            Workflow workflow = workFlowAnnotations[0];
            this.localContext.registerNew(this.generateWorkflowIdentifier(method, workflow), workflow.version(), workflow.description(), correlationId, clientElbId);
            this.registerEventsForArguments(invocation.getArguments());
            invocation.proceed();
            ((FluxRuntimeConnector)this.connectorProvider.get()).submitNewWorkflow(this.localContext.getStateMachineDef());
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            this.localContext.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkForCorrelationId(Object[] arguments) throws IllegalAccessException {
        String[] correlationId = new String[]{null};
        for (Object anArgument : arguments) {
            Field[] allFields = anArgument.getClass().getDeclaredFields();
            Optional<Field> possibleAnnotatedField = Arrays.stream(allFields).filter(field -> String.class.isAssignableFrom(field.getType())).filter(field -> ((CorrelationId[])field.getAnnotationsByType(CorrelationId.class)).length > 0).findAny();
            if (!possibleAnnotatedField.isPresent()) continue;
            Field correlationIdAnnotatedField = possibleAnnotatedField.get();
            boolean originalAccessibility = correlationIdAnnotatedField.isAccessible();
            if (!originalAccessibility) {
                correlationIdAnnotatedField.setAccessible(true);
            }
            try {
                correlationId[0] = (String)correlationIdAnnotatedField.get(anArgument);
                break;
            }
            finally {
                if (!originalAccessibility) {
                    correlationIdAnnotatedField.setAccessible(false);
                }
            }
        }
        return correlationId[0];
    }

    private void registerEventsForArguments(Object[] arguments) throws JsonProcessingException {
        if (arguments.length == 0) {
            return;
        }
        int lengthOfArguments = this.getRealLengthOfArguments(arguments);
        EventData[] eventDatas = new EventData[lengthOfArguments];
        int i = 0;
        for (Object anArgument : arguments) {
            if (anArgument.getClass().isArray()) {
                Object[] objects;
                for (Object anObjectArrayMember : objects = (Object[])anArgument) {
                    this.addToEventDataArray(eventDatas, i, anObjectArrayMember);
                    ++i;
                }
                continue;
            }
            this.addToEventDataArray(eventDatas, i, anArgument);
            ++i;
        }
        this.localContext.addEvents(eventDatas);
    }

    private void addToEventDataArray(EventData[] eventDatas, int i, Object anObject) throws JsonProcessingException {
        String eventName = this.localContext.generateEventName((Event)anObject);
        eventDatas[i] = new EventData(eventName, anObject.getClass().getName(), ((ObjectMapper)this.objectMapperProvider.get()).writeValueAsString(anObject), "client");
    }

    private int getRealLengthOfArguments(Object[] arguments) {
        int len = 0;
        for (Object anArgument : arguments) {
            if (anArgument.getClass().isArray()) {
                Object[] objects = (Object[])anArgument;
                len += objects.length;
                continue;
            }
            ++len;
        }
        return len;
    }

    private void checkForBadSignatures(MethodInvocation invocation) {
        Class<?>[] parameterTypes;
        Method method = invocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            throw new IllegalSignatureException(new MethodId(method), "A workflow method can only return void");
        }
        for (Class<?> aParamType : parameterTypes = method.getParameterTypes()) {
            if (Event.class.isAssignableFrom(aParamType) || aParamType.isArray()) continue;
            throw new IllegalSignatureException(new MethodId(method), "Parameter types should implement the Event interface. Collections of events are also not allowed");
        }
    }

    private String generateWorkflowIdentifier(Method method, Workflow workflow) {
        return new MethodId(method).toString() + "_version" + workflow.version();
    }
}

