/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.impl;

import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hibernate.SessionFactory;

public class SessionFactoryContextImpl
implements SessionFactoryContext {
    private final ImmutableMap<DataSourceType, SessionFactory> sessionFactoryImmutableMap;
    private final DataSourceType defaultDataSourceType;
    private final ThreadLocal<SessionFactory> currentSessionFactory = new ThreadLocal();

    public SessionFactoryContextImpl(Map<DataSourceType, SessionFactory> sessionFactoryMap, DataSourceType defaultType) {
        this.sessionFactoryImmutableMap = ImmutableMap.copyOf(sessionFactoryMap);
        this.defaultDataSourceType = defaultType;
        assert (this.sessionFactoryImmutableMap.get((Object)this.defaultDataSourceType) != null) : "DataSource of type " + this.defaultDataSourceType.name() + " not configured";
    }

    public SessionFactoryContextImpl(Map<DataSourceType, SessionFactory> sessionFactoryMap) {
        this(sessionFactoryMap, DataSourceType.READ_WRITE);
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.currentSessionFactory.get();
    }

    @Override
    public void useSessionFactory(DataSourceType type) {
        SessionFactory sessionFactory = (SessionFactory)this.sessionFactoryImmutableMap.get((Object)type);
        if (sessionFactory == null) {
            sessionFactory = (SessionFactory)this.sessionFactoryImmutableMap.get((Object)this.defaultDataSourceType);
        }
        this.currentSessionFactory.set(sessionFactory);
    }

    @Override
    public void useDefault() {
        this.useSessionFactory(this.defaultDataSourceType);
    }

    @Override
    public void clear() {
        this.currentSessionFactory.remove();
    }
}

