/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.interceptor;

import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import javax.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class TransactionInterceptor
implements MethodInterceptor {
    private final Provider<SessionFactoryContext> contextProvider;

    public TransactionInterceptor(Provider<SessionFactoryContext> contextProvider) {
        this.contextProvider = contextProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Transaction transaction = null;
        Session session = null;
        SessionFactoryContext context = (SessionFactoryContext)this.contextProvider.get();
        try {
            SessionFactory currentSessionFactory = context.getSessionFactory();
            if (currentSessionFactory != null) {
                session = currentSessionFactory.getCurrentSession();
            }
        }
        catch (HibernateException currentSessionFactory) {
            // empty catch block
        }
        if (session == null) {
            SelectDataSource selectedDS = invocation.getMethod().getAnnotation(SelectDataSource.class);
            if (selectedDS == null) {
                context.useDefault();
            } else {
                context.useSessionFactory(selectedDS.value());
            }
            session = context.getSessionFactory().openSession();
            ManagedSessionContext.bind((Session)session);
            transaction = session.getTransaction();
            transaction.begin();
        }
        try {
            Object result = invocation.proceed();
            if (transaction != null) {
                transaction.commit();
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            if (transaction != null && session != null) {
                ManagedSessionContext.unbind((SessionFactory)context.getSessionFactory());
                session.close();
                context.clear();
            }
        }
    }
}

