/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.interceptor;

import com.flipkart.flux.persistence.CryptHashGenerator;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.shard.ShardId;
import javax.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class TransactionInterceptor
implements MethodInterceptor {
    private static final Logger logger = LogManager.getLogger(TransactionInterceptor.class);
    private final Provider<SessionFactoryContext> contextProvider;

    public TransactionInterceptor(Provider<SessionFactoryContext> contextProvider) {
        this.contextProvider = contextProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Transaction transaction = null;
        Session session = null;
        SessionFactoryContext context = (SessionFactoryContext)this.contextProvider.get();
        try {
            session = context.getThreadLocalSession();
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        if (session == null) {
            SessionFactory sessionFactory = null;
            try {
                Storage storage = invocation.getMethod().getAnnotation(SelectDataSource.class).storage();
                block5 : switch (storage) {
                    case SHARDED: {
                        try {
                            DataSourceType dataSourceType = invocation.getMethod().getAnnotation(SelectDataSource.class).type();
                            switch (dataSourceType) {
                                case READ_ONLY: {
                                    Object[] args = invocation.getArguments();
                                    ShardId shardId = (ShardId)args[0];
                                    sessionFactory = context.getROSessionFactory(shardId);
                                    break block5;
                                }
                                case READ_WRITE: {
                                    Object[] args = invocation.getArguments();
                                    String shardKey = (String)args[0];
                                    String shardKeyPrefix = CryptHashGenerator.getUniformCryptHash(shardKey);
                                    sessionFactory = context.getRWSessionFactory(shardKeyPrefix);
                                    break block5;
                                }
                            }
                            break;
                        }
                        catch (Exception ex) {
                            logger.error("Current Transactional Method doesn't have annotation @SelectDataSource Method_name:{} {}", (Object)invocation.getMethod().getName(), (Object)ex.getStackTrace());
                            return new Error("Something wrong with Method's annotations " + ex.getMessage());
                        }
                    }
                    case SCHEDULER: {
                        sessionFactory = context.getSchedulerSessionFactory();
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Current Transactional Method doesn't have annotation @SelectDataSourceType Method_name:{} {}", (Object)invocation.getMethod().getName(), (Object)ex.getStackTrace());
                return new Error("Something wrong with Method's annotations " + ex.getMessage());
            }
            session = sessionFactory.openSession();
            context.setThreadLocalSession(session);
            logger.debug("Open new session for the thread transaction started, using it: {}, {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
            transaction = session.getTransaction();
            transaction.begin();
            try {
                Object result = invocation.proceed();
                transaction.commit();
                Object object = result;
                return object;
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
            finally {
                logger.debug("Transaction completed for method : {} {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
                if (session != null) {
                    session.close();
                }
                context.clear();
                logger.debug("Clearing session from ThreadLocal Context : {} {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
            }
        }
        Object result = invocation.proceed();
        logger.debug("Use old session for the thread, reusing it: {}, {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
        return result;
    }
}

