/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.runner;

import com.flipkart.flux.FluxRuntimeRole;
import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.guice.module.ConfigModule;
import com.flipkart.flux.runner.Modules;
import com.flipkart.polyguice.core.support.Polyguice;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class GuiceJunit4Runner
extends BlockJUnit4ClassRunner {
    static final Map<Set<Class<? extends AbstractModule>>, Polyguice> polyguiceMap = new HashMap<Set<Class<? extends AbstractModule>>, Polyguice>();
    static ConfigModule configModuleForOrchestration;
    static ConfigModule configModuleForExecution;

    public GuiceJunit4Runner(Class<?> klass) throws InitializationError, IOException {
        super(klass);
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        Modules moduleAnnotation = testInstance.getClass().getAnnotation(Modules.class);
        if (moduleAnnotation == null) {
            throw new RuntimeException("You now have to supply a @Modules annotation to use GuiceJunit4Runner");
        }
        if (moduleAnnotation.executionModules().length > 0) {
            configModuleForExecution = new ConfigModule(FluxRuntimeRole.EXECUTION);
            Polyguice polyInstance = this.getPolyInstance(moduleAnnotation.executionModules(), configModuleForExecution);
            Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(InjectFromRole.class) != null).filter(field -> field.getAnnotation(InjectFromRole.class).value().equals((Object)FluxRuntimeRole.EXECUTION)).forEach(field -> {
                try {
                    field.setAccessible(true);
                    String namedInstance = field.getAnnotation(InjectFromRole.class).name();
                    if (namedInstance.length() > 0) {
                        field.set(testInstance, polyInstance.getComponentContext().getInstance(namedInstance, field.getType()));
                    } else {
                        field.set(testInstance, polyInstance.getComponentContext().getInstance(field.getType()));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
        }
        if (moduleAnnotation.orchestrationModules().length > 0) {
            configModuleForOrchestration = new ConfigModule(FluxRuntimeRole.ORCHESTRATION);
            Polyguice polyInstance2 = this.getPolyInstance(moduleAnnotation.orchestrationModules(), configModuleForOrchestration);
            Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(InjectFromRole.class) != null).filter(field -> field.getAnnotation(InjectFromRole.class).value().equals((Object)FluxRuntimeRole.ORCHESTRATION)).forEach(field -> {
                try {
                    field.setAccessible(true);
                    String namedInstance = field.getAnnotation(InjectFromRole.class).name();
                    if (namedInstance.length() > 0) {
                        field.set(testInstance, polyInstance2.getComponentContext().getInstance(namedInstance, field.getType()));
                    } else {
                        field.set(testInstance, polyInstance2.getComponentContext().getInstance(field.getType()));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
        }
        return testInstance;
    }

    private Polyguice getPolyInstance(Class<? extends AbstractModule>[] modules, ConfigModule configModule) {
        HashSet moduleClassSet = new HashSet();
        Collections.addAll(moduleClassSet, modules);
        if (!polyguiceMap.containsKey(moduleClassSet)) {
            AbstractModule[] createdModules = (AbstractModule[])moduleClassSet.stream().filter(aClass -> aClass != ConfigModule.class).map(aClass -> {
                try {
                    return (AbstractModule)aClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(value -> new AbstractModule[value + 1]);
            createdModules[createdModules.length - 1] = configModule;
            polyguiceMap.put(moduleClassSet, new Polyguice().modules((Module[])createdModules).registerConfigurationProvider(configModule.getConfigProvider()).prepare());
        }
        return polyguiceMap.get(moduleClassSet);
    }
}

