/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.interceptor;

import com.flipkart.flux.interceptor.InterceptedClass;
import com.flipkart.flux.interceptor.TestModule;
import com.flipkart.flux.persistence.CryptHashGenerator;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.impl.SessionFactoryContextImpl;
import com.flipkart.flux.shard.ShardId;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashMap;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.junit.Test;
import org.mockito.Mockito;

public class TransactionInterceptorTest {
    @Test
    public void testTransactionInterceptorWithSessionFactoryContext() {
        HashMap<ShardId, SessionFactory> RWSessionFactoryMap = new HashMap<ShardId, SessionFactory>();
        HashMap<ShardId, SessionFactory> ROSessionFactoryMap = new HashMap<ShardId, SessionFactory>();
        HashMap<String, ShardId> shardStringToShardIdMap = new HashMap<String, ShardId>();
        SessionFactory schedulerSessionFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        ShardId[] shardIds = new ShardId[4];
        SessionFactory[] rwSessionFactoriesArray = new SessionFactory[4];
        Session[] rwSessions = new Session[4];
        Transaction[] rwTransactions = new Transaction[4];
        SessionFactory[] roSessionFactoriesArray = new SessionFactory[4];
        Session[] roSessions = new Session[4];
        Transaction[] roTransactions = new Transaction[4];
        Session mockedSchedulerSession = (Session)Mockito.mock(Session.class);
        Transaction mockedSchedulerTransaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)schedulerSessionFactory.openSession()).thenReturn((Object)mockedSchedulerSession);
        Mockito.when((Object)schedulerSessionFactory.getCurrentSession()).thenReturn(null, (Object[])new Session[]{mockedSchedulerSession});
        Mockito.when((Object)mockedSchedulerSession.getTransaction()).thenReturn((Object)mockedSchedulerTransaction);
        Integer i = 0;
        while (i < 4) {
            shardIds[i.intValue()] = new ShardId(i.intValue());
            Object masterWriteSF = (SessionFactory)Mockito.mock(SessionFactory.class);
            Object mockedShardedReadWriteSession = (Session)Mockito.mock(Session.class);
            Transaction mockedShardedReadWriteTransaction = (Transaction)Mockito.mock(Transaction.class);
            rwSessionFactoriesArray[i.intValue()] = masterWriteSF;
            rwSessions[i.intValue()] = mockedShardedReadWriteSession;
            rwTransactions[i.intValue()] = mockedShardedReadWriteTransaction;
            RWSessionFactoryMap.put(shardIds[i], (SessionFactory)masterWriteSF);
            Mockito.when((Object)rwSessionFactoriesArray[i].openSession()).thenReturn((Object)rwSessions[i]);
            Mockito.when((Object)rwSessionFactoriesArray[i].getCurrentSession()).thenReturn(null, (Object[])new Session[]{rwSessions[i]});
            Mockito.when((Object)rwSessions[i].getTransaction()).thenReturn((Object)rwTransactions[i]);
            SessionFactory slaveReadSF = (SessionFactory)Mockito.mock(SessionFactory.class);
            Session mockedShardedReadOnlySession = (Session)Mockito.mock(Session.class);
            Transaction mockedShardedReadOnlyTransaction = (Transaction)Mockito.mock(Transaction.class);
            roSessionFactoriesArray[i.intValue()] = slaveReadSF;
            roSessions[i.intValue()] = mockedShardedReadOnlySession;
            roTransactions[i.intValue()] = mockedShardedReadOnlyTransaction;
            ROSessionFactoryMap.put(shardIds[i], slaveReadSF);
            Mockito.when((Object)roSessionFactoriesArray[i].openSession()).thenReturn((Object)roSessions[i]);
            Mockito.when((Object)roSessionFactoriesArray[i].getCurrentSession()).thenReturn(null, (Object[])new Session[]{roSessions[i]});
            Mockito.when((Object)roSessions[i].getTransaction()).thenReturn((Object)roTransactions[i]);
            masterWriteSF = i;
            i = i + 1;
            mockedShardedReadWriteSession = i;
        }
        assert (RWSessionFactoryMap.size() == 4);
        assert (ROSessionFactoryMap.size() == 4);
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j = 0; j < 16; ++j) {
                String dbNameSuffix = Integer.toHexString(i2) + Integer.toHexString(j);
                shardStringToShardIdMap.put(dbNameSuffix, shardIds[i2 / 4]);
            }
        }
        SessionFactoryContextImpl context = new SessionFactoryContextImpl(RWSessionFactoryMap, ROSessionFactoryMap, shardStringToShardIdMap, schedulerSessionFactory);
        for (int i3 = 0; i3 <= 1000; ++i3) {
            String random_uuid = UUID.randomUUID().toString();
            String shardKey = CryptHashGenerator.getUniformCryptHash((String)random_uuid);
            ShardId shardId = (ShardId)shardStringToShardIdMap.get(shardKey);
            Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule((SessionFactoryContext)context, rwSessions[shardId.getShardId()], roSessions[shardId.getShardId()], mockedSchedulerSession)});
            InterceptedClass obj = (InterceptedClass)injector.getInstance(InterceptedClass.class);
            obj.verifySessionFactoryAndSessionAndTransactionForShardedMaster(random_uuid);
            obj.verifySessionFactoryAndSessionAndTransactionForShardedSlave(shardId);
            obj.verifySessionFactoryAndSessionAndTransactionForRedriverHost();
        }
    }
}

