/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.interceptor;

import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.shard.ShardId;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.transaction.Transactional;
import org.hibernate.Session;
import org.junit.Assert;

public class InterceptedClass {
    @Inject
    private SessionFactoryContext context;
    @Inject
    @Named(value="shardedReadWriteSession")
    private Session shardedReadWriteSession;
    @Inject
    @Named(value="shardedReadOnlySession")
    private Session shardedReadOnlySession;
    @Inject
    @Named(value="schedulerSession")
    private Session schedulerSession;

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void verifySessionFactoryAndSessionAndTransactionForShardedMaster(String shardKey) {
        Assert.assertSame((Object)this.context.getThreadLocalSession(), (Object)this.shardedReadWriteSession);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public void verifySessionFactoryAndSessionAndTransactionForShardedSlave(ShardId shardId) {
        Assert.assertSame((Object)this.context.getThreadLocalSession(), (Object)this.shardedReadOnlySession);
    }

    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public void verifySessionFactoryAndSessionAndTransactionForRedriverHost() {
        Assert.assertSame((Object)this.context.getThreadLocalSession(), (Object)this.schedulerSession);
    }
}

