/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.examples.externalevents;

import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.model.Workflow;
import com.flipkart.flux.examples.externalevents.ManualSellerVerificationService;
import com.flipkart.flux.examples.externalevents.NotificationService;
import com.flipkart.flux.examples.externalevents.SellerData;
import com.flipkart.flux.examples.externalevents.SellerDataService;
import com.flipkart.flux.examples.externalevents.SellerId;
import com.flipkart.flux.examples.externalevents.SellerVerificationStatus;
import javax.inject.Inject;

public class ManualSellerVerificationFlow {
    @Inject
    private SellerDataService sellerDataService;
    @Inject
    private ManualSellerVerificationService sellerVerificationService;
    @Inject
    NotificationService notificationService;

    @Workflow(version=1L)
    public void verifySeller(SellerId sellerId) {
        SellerData sellerData = this.sellerDataService.retrieveSellerData(sellerId);
        this.notificationService.notifyCustomerSupport(sellerData);
        SellerVerificationStatus sellerVerificationStatus = this.sellerVerificationService.waitForVerification(null);
        this.confirmVerificationStatus(sellerVerificationStatus);
    }

    @Task(version=1L, timeout=1000L, retries=2L)
    public void confirmVerificationStatus(SellerVerificationStatus sellerVerificationStatus) {
        if (sellerVerificationStatus.isVerifiedSeller()) {
            this.notificationService.sendWelcomeEmail(sellerVerificationStatus.getSellerId());
        }
    }
}

