/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.examples.externalevents;

import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.client.runtime.FluxRuntimeConnectorHttpImpl;
import com.flipkart.flux.examples.externalevents.ManualSellerVerificationFlow;
import com.flipkart.flux.examples.externalevents.SellerId;
import com.flipkart.flux.examples.externalevents.SellerVerificationStatus;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.UUID;

public class RunManualSellerVerificationWorkflow {
    public static void main(String ... args) throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new FluxClientComponentModule(), new FluxClientInterceptorModule()});
        ManualSellerVerificationFlow manualSellerVerificationFlow = (ManualSellerVerificationFlow)injector.getInstance(ManualSellerVerificationFlow.class);
        String randomCorrelationId = UUID.randomUUID().toString().substring(0, 16);
        manualSellerVerificationFlow.verifySeller(new SellerId(1L, randomCorrelationId));
        System.out.println("[Main] The workflow is active. Try checking in the UI first & then post an external event against " + randomCorrelationId);
        System.out.println("[Main] Sleeping for 2 seconds before posting data to flux runtime");
        Thread.sleep(2000L);
        new FluxRuntimeConnectorHttpImpl(Long.valueOf(1000L), Long.valueOf(1000L), "http://localhost:9998/api/machines").submitEvent("sellerVerification", (Object)new SellerVerificationStatus(new SellerId(1L), true), randomCorrelationId, "Manual Trigger From Customer Support");
        System.out.println("[Main] Posted data to flux runtime, the workflow should have continued");
    }
}

