/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.examples.replayevents;

import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.examples.replayevents.IntegerEvent;
import com.flipkart.flux.examples.replayevents.ParamEvent;
import com.flipkart.flux.examples.replayevents.ReplayEventWorkflow;
import com.flipkart.flux.examples.replayevents.ReplayEventWorkflow2;
import com.flipkart.flux.examples.replayevents.StartEvent;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;

public class RunReplayEventWorkflow {
    public static void main(String[] args) throws InterruptedException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new FluxClientComponentModule(), new FluxClientInterceptorModule()});
        ReplayEventWorkflow replayEventWorkflow = (ReplayEventWorkflow)injector.getInstance(ReplayEventWorkflow.class);
        FluxRuntimeConnector fluxHttpConnector = (FluxRuntimeConnector)injector.getInstance(FluxRuntimeConnector.class);
        String correlation_id_1 = "example_replay_event_workflow_100";
        replayEventWorkflow.create(new StartEvent(correlation_id_1));
        System.out.println("[Main] Sleeping for 10 seconds before posting replay event to flux runtime so that replayable state is completed");
        Thread.sleep(10000L);
        fluxHttpConnector.submitReplayEvent("someReplayEvent1", (Object)new ParamEvent("task44", false), correlation_id_1, null);
        System.out.println("[Main] Posted replay event to flux runtime, the workflow should have continued");
        ReplayEventWorkflow2 replayEventWorkflow2 = (ReplayEventWorkflow2)injector.getInstance(ReplayEventWorkflow2.class);
        String correlation_id_2 = "example_replay_event_workflow_71";
        replayEventWorkflow2.create(new StartEvent(correlation_id_2));
        for (int i = 0; i < 6; ++i) {
            System.out.println("[Main] Sleeping for 10 seconds before posting replay event to flux runtime so that replayable state is completed");
            Thread.sleep(10000L);
            if (i % 2 == 0) {
                fluxHttpConnector.submitReplayEvent("RE1", (Object)new IntegerEvent(5), correlation_id_2, "my-replay-event");
            } else {
                fluxHttpConnector.submitReplayEvent("RE2", (Object)new IntegerEvent(5), correlation_id_2, "example");
            }
            System.out.println("[Main] Posted replay event 2 to flux runtime iteration:," + i + " the workflow should have continued");
        }
    }
}

