/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.type;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.usertype.UserType;

public class SetJsonType
implements UserType,
Serializable {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public int[] sqlTypes() {
        return new int[]{2000};
    }

    public Class returnedClass() {
        return Object.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        try {
            st.setString(index, this.serialize(value));
        }
        catch (JsonProcessingException e) {
            throw new SQLException("Cannot serialize object to JSON. Exception " + e.getMessage());
        }
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (value == null) {
            return new HashSet();
        }
        try {
            return this.deSerialize(value);
        }
        catch (IOException e) {
            throw new SQLException("Cannot deserialize json string " + value + ". Exception " + e.getMessage());
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return SerializationHelper.clone((Serializable)((Serializable)value));
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    protected Object deSerialize(String value) throws IOException {
        return MAPPER.readValue(value, (TypeReference)new TypeReference<Set<Object>>(){});
    }

    protected String serialize(Object value) throws JsonProcessingException {
        if (value == null) {
            return null;
        }
        return MAPPER.writeValueAsString(value);
    }
}

