/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="Events")
public class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String name;
    private String type;
    @Enumerated(value=EnumType.STRING)
    private EventStatus status;
    private Long stateMachineInstanceId;
    private String eventData;
    private String eventSource;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    protected Event() {
    }

    public Event(String name, String type, EventStatus status, Long stateMachineInstanceId, String eventData, String eventSource) {
        this.name = name;
        this.type = type;
        this.status = status;
        this.stateMachineInstanceId = stateMachineInstanceId;
        this.eventData = eventData;
        this.eventSource = eventSource;
    }

    public Long getId() {
        return this.id;
    }

    public EventStatus getStatus() {
        return this.status;
    }

    public void setStatus(EventStatus status) {
        this.status = status;
    }

    public Long getStateMachineInstanceId() {
        return this.stateMachineInstanceId;
    }

    public void setStateMachineInstanceId(Long stateMachineInstanceId) {
        this.stateMachineInstanceId = stateMachineInstanceId;
    }

    public String getEventData() {
        return this.eventData;
    }

    public void setEventData(String eventData) {
        this.eventData = eventData;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public Timestamp getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        if (this.eventData != null ? !this.eventData.equals(event.eventData) : event.eventData != null) {
            return false;
        }
        if (this.eventSource != null ? !this.eventSource.equals(event.eventSource) : event.eventSource != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(event.name) : event.name != null) {
            return false;
        }
        if (this.stateMachineInstanceId != null ? !this.stateMachineInstanceId.equals(event.stateMachineInstanceId) : event.stateMachineInstanceId != null) {
            return false;
        }
        if (this.status != event.status) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(event.type) : event.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.stateMachineInstanceId != null ? this.stateMachineInstanceId.hashCode() : 0);
        result = 31 * result + (this.eventData != null ? this.eventData.hashCode() : 0);
        result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
        return result;
    }

    public static enum EventStatus {
        pending,
        triggered;

    }
}

