/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Context {
    protected Long startTime;
    protected String contextId;
    private static final String START = "start";
    protected Map<String, Set<State>> eventToStateDependencyGraph;

    public Context(StateMachine stateMachine) {
        stateMachine.setContext(this);
        this.buildDependencyMap(stateMachine.getStates());
    }

    public abstract void storeData(String var1, Object var2);

    public abstract Object retrieve(String var1);

    public Set<State> getDependantStates(String eventName) {
        Set<State> dependentStates = this.eventToStateDependencyGraph.get(eventName);
        if (dependentStates == null) {
            return Collections.emptySet();
        }
        return dependentStates;
    }

    public Set<State> getInitialStates(Set<String> triggeredEventNames) {
        HashSet<State> initialStates = new HashSet<State>();
        Set<State> startStates = this.eventToStateDependencyGraph.get(START);
        if (startStates != null) {
            initialStates.addAll(startStates);
        }
        for (String aTriggeredEventName : triggeredEventNames) {
            Set<State> statesDependentOnThisEvent = this.eventToStateDependencyGraph.get(aTriggeredEventName);
            if (statesDependentOnThisEvent == null) continue;
            statesDependentOnThisEvent.stream().filter(state1 -> state1.isDependencySatisfied(triggeredEventNames)).forEach(initialStates::add);
        }
        return initialStates;
    }

    public void buildDependencyMap(Set<State> states) {
        this.eventToStateDependencyGraph = new HashMap<String, Set<State>>();
        for (State state : states) {
            if (!state.getDependencies().isEmpty()) {
                for (String eventName : state.getDependencies()) {
                    if (!this.eventToStateDependencyGraph.containsKey(eventName)) {
                        this.eventToStateDependencyGraph.put(eventName, new HashSet());
                    }
                    this.eventToStateDependencyGraph.get(eventName).add(state);
                }
                continue;
            }
            if (!this.eventToStateDependencyGraph.containsKey(START)) {
                this.eventToStateDependencyGraph.put(START, new HashSet());
            }
            this.eventToStateDependencyGraph.get(START).add(state);
        }
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public String getContextId() {
        return this.contextId;
    }
}

