/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import com.flipkart.flux.domain.Context;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachineStatus;
import java.sql.Timestamp;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="StateMachines")
public class StateMachine {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private Long version;
    private String name;
    private String description;
    private String correlationId;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, targetEntity=State.class)
    @JoinColumn(name="stateMachineId")
    private Set<State> states;
    @Enumerated(value=EnumType.STRING)
    private StateMachineStatus status;
    @Transient
    private Set<State> currentStates;
    @Transient
    private Context context;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    protected StateMachine() {
    }

    public StateMachine(Long version, String name, String description, Set<State> states, String correlationId) {
        this.version = version;
        this.name = name;
        this.description = description;
        this.states = states;
        this.correlationId = correlationId;
        this.status = StateMachineStatus.active;
    }

    public Long getId() {
        return this.id;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Set<State> getCurrentStates() {
        return this.currentStates;
    }

    public void setCurrentStates(Set<State> currentStates) {
        this.currentStates = currentStates;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<State> getStates() {
        return this.states;
    }

    public StateMachineStatus getStatus() {
        return this.status;
    }

    public void setStatus(StateMachineStatus status) {
        this.status = status;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public Timestamp getUpdatedAt() {
        return this.updatedAt;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateMachine)) {
            return false;
        }
        StateMachine that = (StateMachine)o;
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.currentStates != null ? !this.currentStates.equals(that.currentStates) : that.currentStates != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.states != null ? !this.states.equals(that.states) : that.states != null) {
            return false;
        }
        if (this.updatedAt != null ? !this.updatedAt.equals(that.updatedAt) : that.updatedAt != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.states != null ? this.states.hashCode() : 0);
        result = 31 * result + (this.currentStates != null ? this.currentStates.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StateMachine{context=" + this.context + ", id='" + this.id + '\'' + ", version=" + this.version + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", states=" + this.states + ", currentStates=" + this.currentStates + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }
}

